/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.XmlDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class XmlDataset
extends Dataset {
    private String type = "Xml";
    private XmlDatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(XmlDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    XmlDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public XmlDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public XmlDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public XmlDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public XmlDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public XmlDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public XmlDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public XmlDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public DatasetLocation location() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().location();
    }

    public XmlDataset withLocation(DatasetLocation location) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XmlDatasetTypeProperties();
        }
        this.innerTypeProperties().withLocation(location);
        return this;
    }

    public Object encodingName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encodingName();
    }

    public XmlDataset withEncodingName(Object encodingName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XmlDatasetTypeProperties();
        }
        this.innerTypeProperties().withEncodingName(encodingName);
        return this;
    }

    public Object nullValue() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().nullValue();
    }

    public XmlDataset withNullValue(Object nullValue) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XmlDatasetTypeProperties();
        }
        this.innerTypeProperties().withNullValue(nullValue);
        return this;
    }

    public DatasetCompression compression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compression();
    }

    public XmlDataset withCompression(DatasetCompression compression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new XmlDatasetTypeProperties();
        }
        this.innerTypeProperties().withCompression(compression);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model XmlDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        if (this.structure() != null) {
            jsonWriter.writeUntypedField("structure", this.structure());
        }
        if (this.schema() != null) {
            jsonWriter.writeUntypedField("schema", this.schema());
        }
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static XmlDataset fromJson(JsonReader jsonReader) throws IOException {
        return (XmlDataset)jsonReader.readObject(reader -> {
            XmlDataset deserializedXmlDataset = new XmlDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedXmlDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedXmlDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedXmlDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedXmlDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedXmlDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedXmlDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedXmlDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedXmlDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedXmlDataset.innerTypeProperties = XmlDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedXmlDataset.withAdditionalProperties(additionalProperties);
            return deserializedXmlDataset;
        });
    }
}

