/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.WebAuthenticationType;
import com.azure.resourcemanager.datafactory.models.WebLinkedServiceTypeProperties;
import java.io.IOException;

public final class WebAnonymousAuthentication
extends WebLinkedServiceTypeProperties {
    private WebAuthenticationType authenticationType = WebAuthenticationType.ANONYMOUS;
    private static final ClientLogger LOGGER = new ClientLogger(WebAnonymousAuthentication.class);

    @Override
    public WebAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    @Override
    public WebAnonymousAuthentication withUrl(Object url) {
        super.withUrl(url);
        return this;
    }

    @Override
    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model WebAnonymousAuthentication"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url());
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static WebAnonymousAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (WebAnonymousAuthentication)jsonReader.readObject(reader -> {
            WebAnonymousAuthentication deserializedWebAnonymousAuthentication = new WebAnonymousAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedWebAnonymousAuthentication.withUrl(reader.readUntyped());
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedWebAnonymousAuthentication.authenticationType = WebAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebAnonymousAuthentication;
        });
    }
}

