/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.TumblingWindowTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.DependencyReference;
import com.azure.resourcemanager.datafactory.models.RetryPolicy;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import com.azure.resourcemanager.datafactory.models.TumblingWindowFrequency;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TumblingWindowTrigger
extends Trigger {
    private String type = "TumblingWindowTrigger";
    private TriggerPipelineReference pipeline;
    private TumblingWindowTriggerTypeProperties innerTypeProperties = new TumblingWindowTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(TumblingWindowTrigger.class);

    @Override
    public String type() {
        return this.type;
    }

    public TriggerPipelineReference pipeline() {
        return this.pipeline;
    }

    public TumblingWindowTrigger withPipeline(TriggerPipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    TumblingWindowTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public TumblingWindowTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public TumblingWindowTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public TumblingWindowFrequency frequency() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().frequency();
    }

    public TumblingWindowTrigger withFrequency(TumblingWindowFrequency frequency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withFrequency(frequency);
        return this;
    }

    public int interval() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().interval();
    }

    public TumblingWindowTrigger withInterval(int interval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withInterval(interval);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().startTime();
    }

    public TumblingWindowTrigger withStartTime(OffsetDateTime startTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime endTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().endTime();
    }

    public TumblingWindowTrigger withEndTime(OffsetDateTime endTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withEndTime(endTime);
        return this;
    }

    public Object delay() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().delay();
    }

    public TumblingWindowTrigger withDelay(Object delay) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withDelay(delay);
        return this;
    }

    public int maxConcurrency() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().maxConcurrency();
    }

    public TumblingWindowTrigger withMaxConcurrency(int maxConcurrency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withMaxConcurrency(maxConcurrency);
        return this;
    }

    public RetryPolicy retryPolicy() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().retryPolicy();
    }

    public TumblingWindowTrigger withRetryPolicy(RetryPolicy retryPolicy) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRetryPolicy(retryPolicy);
        return this;
    }

    public List<DependencyReference> dependsOn() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dependsOn();
    }

    public TumblingWindowTrigger withDependsOn(List<DependencyReference> dependsOn) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new TumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withDependsOn(dependsOn);
        return this;
    }

    @Override
    public void validate() {
        if (this.pipeline() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property pipeline in model TumblingWindowTrigger"));
        }
        this.pipeline().validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model TumblingWindowTrigger"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("pipeline", (JsonSerializable)this.pipeline);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TumblingWindowTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (TumblingWindowTrigger)jsonReader.readObject(reader -> {
            TumblingWindowTrigger deserializedTumblingWindowTrigger = new TumblingWindowTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.withDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.withRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedTumblingWindowTrigger.withAnnotations(annotations);
                    continue;
                }
                if ("pipeline".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.pipeline = TriggerPipelineReference.fromJson(reader);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.innerTypeProperties = TumblingWindowTriggerTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTumblingWindowTrigger.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTumblingWindowTrigger.withAdditionalProperties(additionalProperties);
            return deserializedTumblingWindowTrigger;
        });
    }
}

