/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureBlobFSWriteSettings;
import com.azure.resourcemanager.datafactory.models.AzureBlobStorageWriteSettings;
import com.azure.resourcemanager.datafactory.models.AzureDataLakeStoreWriteSettings;
import com.azure.resourcemanager.datafactory.models.AzureFileStorageWriteSettings;
import com.azure.resourcemanager.datafactory.models.FileServerWriteSettings;
import com.azure.resourcemanager.datafactory.models.LakeHouseWriteSettings;
import com.azure.resourcemanager.datafactory.models.MetadataItem;
import com.azure.resourcemanager.datafactory.models.SftpWriteSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StoreWriteSettings
implements JsonSerializable<StoreWriteSettings> {
    private String type = "StoreWriteSettings";
    private Object maxConcurrentConnections;
    private Object disableMetricsCollection;
    private Object copyBehavior;
    private List<MetadataItem> metadata;
    private Map<String, Object> additionalProperties;

    public String type() {
        return this.type;
    }

    public Object maxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public StoreWriteSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        return this;
    }

    public Object disableMetricsCollection() {
        return this.disableMetricsCollection;
    }

    public StoreWriteSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        this.disableMetricsCollection = disableMetricsCollection;
        return this;
    }

    public Object copyBehavior() {
        return this.copyBehavior;
    }

    public StoreWriteSettings withCopyBehavior(Object copyBehavior) {
        this.copyBehavior = copyBehavior;
        return this;
    }

    public List<MetadataItem> metadata() {
        return this.metadata;
    }

    public StoreWriteSettings withMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public StoreWriteSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.maxConcurrentConnections != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections);
        }
        if (this.disableMetricsCollection != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection);
        }
        if (this.copyBehavior != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.copyBehavior);
        }
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static StoreWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (StoreWriteSettings)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                StoreWriteSettings storeWriteSettings;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("SftpWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = SftpWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("AzureBlobStorageWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = AzureBlobStorageWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("AzureBlobFSWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = AzureBlobFSWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("AzureDataLakeStoreWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = AzureDataLakeStoreWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("FileServerWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = FileServerWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("AzureFileStorageWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = AzureFileStorageWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("LakeHouseWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = LakeHouseWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                storeWriteSettings = StoreWriteSettings.fromJsonKnownDiscriminator(readerToUse.reset());
                return storeWriteSettings;
            }
        });
    }

    static StoreWriteSettings fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (StoreWriteSettings)jsonReader.readObject(reader -> {
            StoreWriteSettings deserializedStoreWriteSettings = new StoreWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedStoreWriteSettings.type = reader.getString();
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedStoreWriteSettings.maxConcurrentConnections = reader.readUntyped();
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedStoreWriteSettings.disableMetricsCollection = reader.readUntyped();
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedStoreWriteSettings.copyBehavior = reader.readUntyped();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedStoreWriteSettings.metadata = metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedStoreWriteSettings.additionalProperties = additionalProperties;
            return deserializedStoreWriteSettings;
        });
    }
}

