/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.DWCopyCommandSettings;
import com.azure.resourcemanager.datafactory.models.PolybaseSettings;
import com.azure.resourcemanager.datafactory.models.SqlDWUpsertSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SqlDWSink
extends CopySink {
    private String type = "SqlDWSink";
    private Object preCopyScript;
    private Object allowPolyBase;
    private PolybaseSettings polyBaseSettings;
    private Object allowCopyCommand;
    private DWCopyCommandSettings copyCommandSettings;
    private Object tableOption;
    private Object sqlWriterUseTableLock;
    private Object writeBehavior;
    private SqlDWUpsertSettings upsertSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object preCopyScript() {
        return this.preCopyScript;
    }

    public SqlDWSink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public Object allowPolyBase() {
        return this.allowPolyBase;
    }

    public SqlDWSink withAllowPolyBase(Object allowPolyBase) {
        this.allowPolyBase = allowPolyBase;
        return this;
    }

    public PolybaseSettings polyBaseSettings() {
        return this.polyBaseSettings;
    }

    public SqlDWSink withPolyBaseSettings(PolybaseSettings polyBaseSettings) {
        this.polyBaseSettings = polyBaseSettings;
        return this;
    }

    public Object allowCopyCommand() {
        return this.allowCopyCommand;
    }

    public SqlDWSink withAllowCopyCommand(Object allowCopyCommand) {
        this.allowCopyCommand = allowCopyCommand;
        return this;
    }

    public DWCopyCommandSettings copyCommandSettings() {
        return this.copyCommandSettings;
    }

    public SqlDWSink withCopyCommandSettings(DWCopyCommandSettings copyCommandSettings) {
        this.copyCommandSettings = copyCommandSettings;
        return this;
    }

    public Object tableOption() {
        return this.tableOption;
    }

    public SqlDWSink withTableOption(Object tableOption) {
        this.tableOption = tableOption;
        return this;
    }

    public Object sqlWriterUseTableLock() {
        return this.sqlWriterUseTableLock;
    }

    public SqlDWSink withSqlWriterUseTableLock(Object sqlWriterUseTableLock) {
        this.sqlWriterUseTableLock = sqlWriterUseTableLock;
        return this;
    }

    public Object writeBehavior() {
        return this.writeBehavior;
    }

    public SqlDWSink withWriteBehavior(Object writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public SqlDWUpsertSettings upsertSettings() {
        return this.upsertSettings;
    }

    public SqlDWSink withUpsertSettings(SqlDWUpsertSettings upsertSettings) {
        this.upsertSettings = upsertSettings;
        return this;
    }

    @Override
    public SqlDWSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SqlDWSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SqlDWSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SqlDWSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SqlDWSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SqlDWSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.polyBaseSettings() != null) {
            this.polyBaseSettings().validate();
        }
        if (this.copyCommandSettings() != null) {
            this.copyCommandSettings().validate();
        }
        if (this.upsertSettings() != null) {
            this.upsertSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        if (this.allowPolyBase != null) {
            jsonWriter.writeUntypedField("allowPolyBase", this.allowPolyBase);
        }
        jsonWriter.writeJsonField("polyBaseSettings", (JsonSerializable)this.polyBaseSettings);
        if (this.allowCopyCommand != null) {
            jsonWriter.writeUntypedField("allowCopyCommand", this.allowCopyCommand);
        }
        jsonWriter.writeJsonField("copyCommandSettings", (JsonSerializable)this.copyCommandSettings);
        if (this.tableOption != null) {
            jsonWriter.writeUntypedField("tableOption", this.tableOption);
        }
        if (this.sqlWriterUseTableLock != null) {
            jsonWriter.writeUntypedField("sqlWriterUseTableLock", this.sqlWriterUseTableLock);
        }
        if (this.writeBehavior != null) {
            jsonWriter.writeUntypedField("writeBehavior", this.writeBehavior);
        }
        jsonWriter.writeJsonField("upsertSettings", (JsonSerializable)this.upsertSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlDWSink fromJson(JsonReader jsonReader) throws IOException {
        return (SqlDWSink)jsonReader.readObject(reader -> {
            SqlDWSink deserializedSqlDWSink = new SqlDWSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSqlDWSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSqlDWSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSqlDWSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSqlDWSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSqlDWSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSqlDWSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlDWSink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedSqlDWSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("allowPolyBase".equals(fieldName)) {
                    deserializedSqlDWSink.allowPolyBase = reader.readUntyped();
                    continue;
                }
                if ("polyBaseSettings".equals(fieldName)) {
                    deserializedSqlDWSink.polyBaseSettings = PolybaseSettings.fromJson(reader);
                    continue;
                }
                if ("allowCopyCommand".equals(fieldName)) {
                    deserializedSqlDWSink.allowCopyCommand = reader.readUntyped();
                    continue;
                }
                if ("copyCommandSettings".equals(fieldName)) {
                    deserializedSqlDWSink.copyCommandSettings = DWCopyCommandSettings.fromJson(reader);
                    continue;
                }
                if ("tableOption".equals(fieldName)) {
                    deserializedSqlDWSink.tableOption = reader.readUntyped();
                    continue;
                }
                if ("sqlWriterUseTableLock".equals(fieldName)) {
                    deserializedSqlDWSink.sqlWriterUseTableLock = reader.readUntyped();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedSqlDWSink.writeBehavior = reader.readUntyped();
                    continue;
                }
                if ("upsertSettings".equals(fieldName)) {
                    deserializedSqlDWSink.upsertSettings = SqlDWUpsertSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlDWSink.withAdditionalProperties(additionalProperties);
            return deserializedSqlDWSink;
        });
    }
}

