/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SapOdpLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SapOdpLinkedService
extends LinkedService {
    private String type = "SapOdp";
    private SapOdpLinkedServiceTypeProperties innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SapOdpLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    SapOdpLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SapOdpLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public SapOdpLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public SapOdpLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SapOdpLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SapOdpLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public SapOdpLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public Object systemNumber() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().systemNumber();
    }

    public SapOdpLinkedService withSystemNumber(Object systemNumber) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSystemNumber(systemNumber);
        return this;
    }

    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    public SapOdpLinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    public Object language() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().language();
    }

    public SapOdpLinkedService withLanguage(Object language) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLanguage(language);
        return this;
    }

    public Object systemId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().systemId();
    }

    public SapOdpLinkedService withSystemId(Object systemId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSystemId(systemId);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public SapOdpLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public SapOdpLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object messageServer() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().messageServer();
    }

    public SapOdpLinkedService withMessageServer(Object messageServer) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMessageServer(messageServer);
        return this;
    }

    public Object messageServerService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().messageServerService();
    }

    public SapOdpLinkedService withMessageServerService(Object messageServerService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMessageServerService(messageServerService);
        return this;
    }

    public Object sncMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncMode();
    }

    public SapOdpLinkedService withSncMode(Object sncMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncMode(sncMode);
        return this;
    }

    public Object sncMyName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncMyName();
    }

    public SapOdpLinkedService withSncMyName(Object sncMyName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncMyName(sncMyName);
        return this;
    }

    public Object sncPartnerName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncPartnerName();
    }

    public SapOdpLinkedService withSncPartnerName(Object sncPartnerName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncPartnerName(sncPartnerName);
        return this;
    }

    public Object sncLibraryPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncLibraryPath();
    }

    public SapOdpLinkedService withSncLibraryPath(Object sncLibraryPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncLibraryPath(sncLibraryPath);
        return this;
    }

    public Object sncQop() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncQop();
    }

    public SapOdpLinkedService withSncQop(Object sncQop) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncQop(sncQop);
        return this;
    }

    public Object x509CertificatePath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().x509CertificatePath();
    }

    public SapOdpLinkedService withX509CertificatePath(Object x509CertificatePath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withX509CertificatePath(x509CertificatePath);
        return this;
    }

    public Object logonGroup() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logonGroup();
    }

    public SapOdpLinkedService withLogonGroup(Object logonGroup) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLogonGroup(logonGroup);
        return this;
    }

    public Object subscriberName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().subscriberName();
    }

    public SapOdpLinkedService withSubscriberName(Object subscriberName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSubscriberName(subscriberName);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public SapOdpLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SapOdpLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapOdpLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SapOdpLinkedService)jsonReader.readObject(reader -> {
            SapOdpLinkedService deserializedSapOdpLinkedService = new SapOdpLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSapOdpLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSapOdpLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapOdpLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapOdpLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapOdpLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSapOdpLinkedService.innerTypeProperties = SapOdpLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapOdpLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapOdpLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedSapOdpLinkedService;
        });
    }
}

