/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SalesforceServiceCloudV2Source
extends CopySource {
    private String type = "SalesforceServiceCloudV2Source";
    private Object soqlQuery;
    private Object query;
    private Object includeDeletedObjects;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object soqlQuery() {
        return this.soqlQuery;
    }

    public SalesforceServiceCloudV2Source withSoqlQuery(Object soqlQuery) {
        this.soqlQuery = soqlQuery;
        return this;
    }

    public Object query() {
        return this.query;
    }

    public SalesforceServiceCloudV2Source withQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object includeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    public SalesforceServiceCloudV2Source withIncludeDeletedObjects(Object includeDeletedObjects) {
        this.includeDeletedObjects = includeDeletedObjects;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public SalesforceServiceCloudV2Source withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Source withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Source withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Source withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Source withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.soqlQuery != null) {
            jsonWriter.writeUntypedField("SOQLQuery", this.soqlQuery);
        }
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.includeDeletedObjects != null) {
            jsonWriter.writeUntypedField("includeDeletedObjects", this.includeDeletedObjects);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceServiceCloudV2Source fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceServiceCloudV2Source)jsonReader.readObject(reader -> {
            SalesforceServiceCloudV2Source deserializedSalesforceServiceCloudV2Source = new SalesforceServiceCloudV2Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.type = reader.getString();
                    continue;
                }
                if ("SOQLQuery".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.soqlQuery = reader.readUntyped();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.query = reader.readUntyped();
                    continue;
                }
                if ("includeDeletedObjects".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.includeDeletedObjects = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceServiceCloudV2Source.withAdditionalProperties(additionalProperties);
            return deserializedSalesforceServiceCloudV2Source;
        });
    }
}

