/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.PowerQuerySink;
import java.io.IOException;
import java.util.List;

public final class PowerQuerySinkMapping
implements JsonSerializable<PowerQuerySinkMapping> {
    private String queryName;
    private List<PowerQuerySink> dataflowSinks;

    public String queryName() {
        return this.queryName;
    }

    public PowerQuerySinkMapping withQueryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public List<PowerQuerySink> dataflowSinks() {
        return this.dataflowSinks;
    }

    public PowerQuerySinkMapping withDataflowSinks(List<PowerQuerySink> dataflowSinks) {
        this.dataflowSinks = dataflowSinks;
        return this;
    }

    public void validate() {
        if (this.dataflowSinks() != null) {
            this.dataflowSinks().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queryName", this.queryName);
        jsonWriter.writeArrayField("dataflowSinks", this.dataflowSinks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PowerQuerySinkMapping fromJson(JsonReader jsonReader) throws IOException {
        return (PowerQuerySinkMapping)jsonReader.readObject(reader -> {
            PowerQuerySinkMapping deserializedPowerQuerySinkMapping = new PowerQuerySinkMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryName".equals(fieldName)) {
                    deserializedPowerQuerySinkMapping.queryName = reader.getString();
                    continue;
                }
                if ("dataflowSinks".equals(fieldName)) {
                    List dataflowSinks;
                    deserializedPowerQuerySinkMapping.dataflowSinks = dataflowSinks = reader.readArray(reader1 -> PowerQuerySink.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPowerQuerySinkMapping;
        });
    }
}

