/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.EntityReference;
import java.io.IOException;

public final class PackageStore
implements JsonSerializable<PackageStore> {
    private String name;
    private EntityReference packageStoreLinkedService;
    private static final ClientLogger LOGGER = new ClientLogger(PackageStore.class);

    public String name() {
        return this.name;
    }

    public PackageStore withName(String name) {
        this.name = name;
        return this;
    }

    public EntityReference packageStoreLinkedService() {
        return this.packageStoreLinkedService;
    }

    public PackageStore withPackageStoreLinkedService(EntityReference packageStoreLinkedService) {
        this.packageStoreLinkedService = packageStoreLinkedService;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model PackageStore"));
        }
        if (this.packageStoreLinkedService() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property packageStoreLinkedService in model PackageStore"));
        }
        this.packageStoreLinkedService().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("packageStoreLinkedService", (JsonSerializable)this.packageStoreLinkedService);
        return jsonWriter.writeEndObject();
    }

    public static PackageStore fromJson(JsonReader jsonReader) throws IOException {
        return (PackageStore)jsonReader.readObject(reader -> {
            PackageStore deserializedPackageStore = new PackageStore();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPackageStore.name = reader.getString();
                    continue;
                }
                if ("packageStoreLinkedService".equals(fieldName)) {
                    deserializedPackageStore.packageStoreLinkedService = EntityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPackageStore;
        });
    }
}

