/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.MySqlLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MySqlLinkedService
extends LinkedService {
    private String type = "MySql";
    private MySqlLinkedServiceTypeProperties innerTypeProperties = new MySqlLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(MySqlLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    MySqlLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public MySqlLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public MySqlLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public MySqlLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MySqlLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public MySqlLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object driverVersion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().driverVersion();
    }

    public MySqlLinkedService withDriverVersion(Object driverVersion) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDriverVersion(driverVersion);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public MySqlLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public MySqlLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public Object port() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().port();
    }

    public MySqlLinkedService withPort(Object port) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPort(port);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public MySqlLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    public MySqlLinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    public Object sslMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslMode();
    }

    public MySqlLinkedService withSslMode(Object sslMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslMode(sslMode);
        return this;
    }

    public Object useSystemTrustStore() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useSystemTrustStore();
    }

    public MySqlLinkedService withUseSystemTrustStore(Object useSystemTrustStore) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseSystemTrustStore(useSystemTrustStore);
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public MySqlLinkedService withPassword(AzureKeyVaultSecretReference password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public MySqlLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public Object allowZeroDateTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().allowZeroDateTime();
    }

    public MySqlLinkedService withAllowZeroDateTime(Object allowZeroDateTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAllowZeroDateTime(allowZeroDateTime);
        return this;
    }

    public Object connectionTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionTimeout();
    }

    public MySqlLinkedService withConnectionTimeout(Object connectionTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionTimeout(connectionTimeout);
        return this;
    }

    public Object convertZeroDateTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().convertZeroDateTime();
    }

    public MySqlLinkedService withConvertZeroDateTime(Object convertZeroDateTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConvertZeroDateTime(convertZeroDateTime);
        return this;
    }

    public Object guidFormat() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().guidFormat();
    }

    public MySqlLinkedService withGuidFormat(Object guidFormat) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withGuidFormat(guidFormat);
        return this;
    }

    public Object sslCert() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslCert();
    }

    public MySqlLinkedService withSslCert(Object sslCert) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslCert(sslCert);
        return this;
    }

    public Object sslKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslKey();
    }

    public MySqlLinkedService withSslKey(Object sslKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslKey(sslKey);
        return this;
    }

    public Object treatTinyAsBoolean() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().treatTinyAsBoolean();
    }

    public MySqlLinkedService withTreatTinyAsBoolean(Object treatTinyAsBoolean) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MySqlLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTreatTinyAsBoolean(treatTinyAsBoolean);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model MySqlLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MySqlLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (MySqlLinkedService)jsonReader.readObject(reader -> {
            MySqlLinkedService deserializedMySqlLinkedService = new MySqlLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedMySqlLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedMySqlLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMySqlLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedMySqlLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMySqlLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedMySqlLinkedService.innerTypeProperties = MySqlLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMySqlLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMySqlLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedMySqlLinkedService;
        });
    }
}

