/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.MongoDbCursorMethodsProperties;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MongoDbAtlasSource
extends CopySource {
    private String type = "MongoDbAtlasSource";
    private Object filter;
    private MongoDbCursorMethodsProperties cursorMethods;
    private Object batchSize;
    private Object queryTimeout;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object filter() {
        return this.filter;
    }

    public MongoDbAtlasSource withFilter(Object filter) {
        this.filter = filter;
        return this;
    }

    public MongoDbCursorMethodsProperties cursorMethods() {
        return this.cursorMethods;
    }

    public MongoDbAtlasSource withCursorMethods(MongoDbCursorMethodsProperties cursorMethods) {
        this.cursorMethods = cursorMethods;
        return this;
    }

    public Object batchSize() {
        return this.batchSize;
    }

    public MongoDbAtlasSource withBatchSize(Object batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Object queryTimeout() {
        return this.queryTimeout;
    }

    public MongoDbAtlasSource withQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public MongoDbAtlasSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public MongoDbAtlasSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public MongoDbAtlasSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public MongoDbAtlasSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public MongoDbAtlasSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.cursorMethods() != null) {
            this.cursorMethods().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.filter != null) {
            jsonWriter.writeUntypedField("filter", this.filter);
        }
        jsonWriter.writeJsonField("cursorMethods", (JsonSerializable)this.cursorMethods);
        if (this.batchSize != null) {
            jsonWriter.writeUntypedField("batchSize", this.batchSize);
        }
        if (this.queryTimeout != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MongoDbAtlasSource fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbAtlasSource)jsonReader.readObject(reader -> {
            MongoDbAtlasSource deserializedMongoDbAtlasSource = new MongoDbAtlasSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.type = reader.getString();
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.filter = reader.readUntyped();
                    continue;
                }
                if ("cursorMethods".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.cursorMethods = MongoDbCursorMethodsProperties.fromJson(reader);
                    continue;
                }
                if ("batchSize".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.batchSize = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedMongoDbAtlasSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMongoDbAtlasSource.withAdditionalProperties(additionalProperties);
            return deserializedMongoDbAtlasSource;
        });
    }
}

