/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MapperConnection;
import com.azure.resourcemanager.datafactory.models.MapperTable;
import java.io.IOException;
import java.util.List;

public final class MapperSourceConnectionsInfo
implements JsonSerializable<MapperSourceConnectionsInfo> {
    private List<MapperTable> sourceEntities;
    private MapperConnection connection;

    public List<MapperTable> sourceEntities() {
        return this.sourceEntities;
    }

    public MapperSourceConnectionsInfo withSourceEntities(List<MapperTable> sourceEntities) {
        this.sourceEntities = sourceEntities;
        return this;
    }

    public MapperConnection connection() {
        return this.connection;
    }

    public MapperSourceConnectionsInfo withConnection(MapperConnection connection) {
        this.connection = connection;
        return this;
    }

    public void validate() {
        if (this.sourceEntities() != null) {
            this.sourceEntities().forEach(e -> e.validate());
        }
        if (this.connection() != null) {
            this.connection().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sourceEntities", this.sourceEntities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("connection", (JsonSerializable)this.connection);
        return jsonWriter.writeEndObject();
    }

    public static MapperSourceConnectionsInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MapperSourceConnectionsInfo)jsonReader.readObject(reader -> {
            MapperSourceConnectionsInfo deserializedMapperSourceConnectionsInfo = new MapperSourceConnectionsInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceEntities".equals(fieldName)) {
                    List sourceEntities;
                    deserializedMapperSourceConnectionsInfo.sourceEntities = sourceEntities = reader.readArray(reader1 -> MapperTable.fromJson(reader1));
                    continue;
                }
                if ("connection".equals(fieldName)) {
                    deserializedMapperSourceConnectionsInfo.connection = MapperConnection.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperSourceConnectionsInfo;
        });
    }
}

