/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;

public final class LogLocationSettings
implements JsonSerializable<LogLocationSettings> {
    private LinkedServiceReference linkedServiceName;
    private Object path;
    private static final ClientLogger LOGGER = new ClientLogger(LogLocationSettings.class);

    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    public LogLocationSettings withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public Object path() {
        return this.path;
    }

    public LogLocationSettings withPath(Object path) {
        this.path = path;
        return this;
    }

    public void validate() {
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model LogLocationSettings"));
        }
        this.linkedServiceName().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
        if (this.path != null) {
            jsonWriter.writeUntypedField("path", this.path);
        }
        return jsonWriter.writeEndObject();
    }

    public static LogLocationSettings fromJson(JsonReader jsonReader) throws IOException {
        return (LogLocationSettings)jsonReader.readObject(reader -> {
            LogLocationSettings deserializedLogLocationSettings = new LogLocationSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedLogLocationSettings.linkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedLogLocationSettings.path = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogLocationSettings;
        });
    }
}

