/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.LinkedServiceResourceInner;
import java.io.IOException;
import java.util.List;

public final class LinkedServiceListResponse
implements JsonSerializable<LinkedServiceListResponse> {
    private List<LinkedServiceResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedServiceListResponse.class);

    public List<LinkedServiceResourceInner> value() {
        return this.value;
    }

    public LinkedServiceListResponse withValue(List<LinkedServiceResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public LinkedServiceListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model LinkedServiceListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static LinkedServiceListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedServiceListResponse)jsonReader.readObject(reader -> {
            LinkedServiceListResponse deserializedLinkedServiceListResponse = new LinkedServiceListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedLinkedServiceListResponse.value = value = reader.readArray(reader1 -> LinkedServiceResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedLinkedServiceListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedServiceListResponse;
        });
    }
}

