/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeType;
import java.io.IOException;

public final class LinkedIntegrationRuntimeRbacAuthorization
extends LinkedIntegrationRuntimeType {
    private String authorizationType = "RBAC";
    private String resourceId;
    private CredentialReference credential;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedIntegrationRuntimeRbacAuthorization.class);

    @Override
    public String authorizationType() {
        return this.authorizationType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public LinkedIntegrationRuntimeRbacAuthorization withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public LinkedIntegrationRuntimeRbacAuthorization withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model LinkedIntegrationRuntimeRbacAuthorization"));
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("authorizationType", this.authorizationType);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static LinkedIntegrationRuntimeRbacAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedIntegrationRuntimeRbacAuthorization)jsonReader.readObject(reader -> {
            LinkedIntegrationRuntimeRbacAuthorization deserializedLinkedIntegrationRuntimeRbacAuthorization = new LinkedIntegrationRuntimeRbacAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedLinkedIntegrationRuntimeRbacAuthorization.resourceId = reader.getString();
                    continue;
                }
                if ("authorizationType".equals(fieldName)) {
                    deserializedLinkedIntegrationRuntimeRbacAuthorization.authorizationType = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedLinkedIntegrationRuntimeRbacAuthorization.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedIntegrationRuntimeRbacAuthorization;
        });
    }
}

