/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CompressionReadSettings;
import com.azure.resourcemanager.datafactory.models.FormatReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JsonReadSettings
extends FormatReadSettings {
    private String type = "JsonReadSettings";
    private CompressionReadSettings compressionProperties;

    @Override
    public String type() {
        return this.type;
    }

    public CompressionReadSettings compressionProperties() {
        return this.compressionProperties;
    }

    public JsonReadSettings withCompressionProperties(CompressionReadSettings compressionProperties) {
        this.compressionProperties = compressionProperties;
        return this;
    }

    @Override
    public void validate() {
        if (this.compressionProperties() != null) {
            this.compressionProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("compressionProperties", (JsonSerializable)this.compressionProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static JsonReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (JsonReadSettings)jsonReader.readObject(reader -> {
            JsonReadSettings deserializedJsonReadSettings = new JsonReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedJsonReadSettings.type = reader.getString();
                    continue;
                }
                if ("compressionProperties".equals(fieldName)) {
                    deserializedJsonReadSettings.compressionProperties = CompressionReadSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedJsonReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedJsonReadSettings;
        });
    }
}

