/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeState;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeType;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeStatus;
import com.azure.resourcemanager.datafactory.models.SelfHostedIntegrationRuntimeStatus;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class IntegrationRuntimeStatus
implements JsonSerializable<IntegrationRuntimeStatus> {
    private IntegrationRuntimeType type = IntegrationRuntimeType.fromString("IntegrationRuntimeStatus");
    private String dataFactoryName;
    private IntegrationRuntimeState state;
    private Map<String, Object> additionalProperties;

    public IntegrationRuntimeType type() {
        return this.type;
    }

    public String dataFactoryName() {
        return this.dataFactoryName;
    }

    IntegrationRuntimeStatus withDataFactoryName(String dataFactoryName) {
        this.dataFactoryName = dataFactoryName;
        return this;
    }

    public IntegrationRuntimeState state() {
        return this.state;
    }

    IntegrationRuntimeStatus withState(IntegrationRuntimeState state) {
        this.state = state;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntimeStatus withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeStatus fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeStatus)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                IntegrationRuntimeStatus integrationRuntimeStatus;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Managed".equals(discriminatorValue)) {
                    integrationRuntimeStatus = ManagedIntegrationRuntimeStatus.fromJson(readerToUse.reset());
                    return integrationRuntimeStatus;
                }
                if ("SelfHosted".equals(discriminatorValue)) {
                    integrationRuntimeStatus = SelfHostedIntegrationRuntimeStatus.fromJson(readerToUse.reset());
                    return integrationRuntimeStatus;
                }
                integrationRuntimeStatus = IntegrationRuntimeStatus.fromJsonKnownDiscriminator(readerToUse.reset());
                return integrationRuntimeStatus;
            }
        });
    }

    static IntegrationRuntimeStatus fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeStatus)jsonReader.readObject(reader -> {
            IntegrationRuntimeStatus deserializedIntegrationRuntimeStatus = new IntegrationRuntimeStatus();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIntegrationRuntimeStatus.type = IntegrationRuntimeType.fromString(reader.getString());
                    continue;
                }
                if ("dataFactoryName".equals(fieldName)) {
                    deserializedIntegrationRuntimeStatus.dataFactoryName = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedIntegrationRuntimeStatus.state = IntegrationRuntimeState.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntimeStatus.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntimeStatus;
        });
    }
}

