/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.CustomSetupBase;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeCustomSetupScriptProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeDataProxyProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeEdition;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeLicenseType;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeSsisCatalogInfo;
import com.azure.resourcemanager.datafactory.models.PackageStore;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class IntegrationRuntimeSsisProperties
implements JsonSerializable<IntegrationRuntimeSsisProperties> {
    private IntegrationRuntimeSsisCatalogInfo catalogInfo;
    private IntegrationRuntimeLicenseType licenseType;
    private IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties;
    private IntegrationRuntimeDataProxyProperties dataProxyProperties;
    private IntegrationRuntimeEdition edition;
    private List<CustomSetupBase> expressCustomSetupProperties;
    private List<PackageStore> packageStores;
    private CredentialReference credential;
    private Map<String, Object> additionalProperties;

    public IntegrationRuntimeSsisCatalogInfo catalogInfo() {
        return this.catalogInfo;
    }

    public IntegrationRuntimeSsisProperties withCatalogInfo(IntegrationRuntimeSsisCatalogInfo catalogInfo) {
        this.catalogInfo = catalogInfo;
        return this;
    }

    public IntegrationRuntimeLicenseType licenseType() {
        return this.licenseType;
    }

    public IntegrationRuntimeSsisProperties withLicenseType(IntegrationRuntimeLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties() {
        return this.customSetupScriptProperties;
    }

    public IntegrationRuntimeSsisProperties withCustomSetupScriptProperties(IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties) {
        this.customSetupScriptProperties = customSetupScriptProperties;
        return this;
    }

    public IntegrationRuntimeDataProxyProperties dataProxyProperties() {
        return this.dataProxyProperties;
    }

    public IntegrationRuntimeSsisProperties withDataProxyProperties(IntegrationRuntimeDataProxyProperties dataProxyProperties) {
        this.dataProxyProperties = dataProxyProperties;
        return this;
    }

    public IntegrationRuntimeEdition edition() {
        return this.edition;
    }

    public IntegrationRuntimeSsisProperties withEdition(IntegrationRuntimeEdition edition) {
        this.edition = edition;
        return this;
    }

    public List<CustomSetupBase> expressCustomSetupProperties() {
        return this.expressCustomSetupProperties;
    }

    public IntegrationRuntimeSsisProperties withExpressCustomSetupProperties(List<CustomSetupBase> expressCustomSetupProperties) {
        this.expressCustomSetupProperties = expressCustomSetupProperties;
        return this;
    }

    public List<PackageStore> packageStores() {
        return this.packageStores;
    }

    public IntegrationRuntimeSsisProperties withPackageStores(List<PackageStore> packageStores) {
        this.packageStores = packageStores;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public IntegrationRuntimeSsisProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntimeSsisProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.catalogInfo() != null) {
            this.catalogInfo().validate();
        }
        if (this.customSetupScriptProperties() != null) {
            this.customSetupScriptProperties().validate();
        }
        if (this.dataProxyProperties() != null) {
            this.dataProxyProperties().validate();
        }
        if (this.expressCustomSetupProperties() != null) {
            this.expressCustomSetupProperties().forEach(e -> e.validate());
        }
        if (this.packageStores() != null) {
            this.packageStores().forEach(e -> e.validate());
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("catalogInfo", (JsonSerializable)this.catalogInfo);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeJsonField("customSetupScriptProperties", (JsonSerializable)this.customSetupScriptProperties);
        jsonWriter.writeJsonField("dataProxyProperties", (JsonSerializable)this.dataProxyProperties);
        jsonWriter.writeStringField("edition", this.edition == null ? null : this.edition.toString());
        jsonWriter.writeArrayField("expressCustomSetupProperties", this.expressCustomSetupProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("packageStores", this.packageStores, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeSsisProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeSsisProperties)jsonReader.readObject(reader -> {
            IntegrationRuntimeSsisProperties deserializedIntegrationRuntimeSsisProperties = new IntegrationRuntimeSsisProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("catalogInfo".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.catalogInfo = IntegrationRuntimeSsisCatalogInfo.fromJson(reader);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.licenseType = IntegrationRuntimeLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("customSetupScriptProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.customSetupScriptProperties = IntegrationRuntimeCustomSetupScriptProperties.fromJson(reader);
                    continue;
                }
                if ("dataProxyProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.dataProxyProperties = IntegrationRuntimeDataProxyProperties.fromJson(reader);
                    continue;
                }
                if ("edition".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.edition = IntegrationRuntimeEdition.fromString(reader.getString());
                    continue;
                }
                if ("expressCustomSetupProperties".equals(fieldName)) {
                    List expressCustomSetupProperties;
                    deserializedIntegrationRuntimeSsisProperties.expressCustomSetupProperties = expressCustomSetupProperties = reader.readArray(reader1 -> CustomSetupBase.fromJson(reader1));
                    continue;
                }
                if ("packageStores".equals(fieldName)) {
                    List packageStores;
                    deserializedIntegrationRuntimeSsisProperties.packageStores = packageStores = reader.readArray(reader1 -> PackageStore.fromJson(reader1));
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntimeSsisProperties.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntimeSsisProperties;
        });
    }
}

