/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.HDInsightLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class HDInsightLinkedService
extends LinkedService {
    private String type = "HDInsight";
    private HDInsightLinkedServiceTypeProperties innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    HDInsightLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public HDInsightLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public HDInsightLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public HDInsightLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public HDInsightLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public HDInsightLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object clusterUri() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clusterUri();
    }

    public HDInsightLinkedService withClusterUri(Object clusterUri) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClusterUri(clusterUri);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public HDInsightLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public HDInsightLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public LinkedServiceReference linkedServiceName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().linkedServiceName();
    }

    public HDInsightLinkedService withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLinkedServiceName(linkedServiceName);
        return this;
    }

    public LinkedServiceReference hcatalogLinkedServiceName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().hcatalogLinkedServiceName();
    }

    public HDInsightLinkedService withHcatalogLinkedServiceName(LinkedServiceReference hcatalogLinkedServiceName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHcatalogLinkedServiceName(hcatalogLinkedServiceName);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public HDInsightLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public Object isEspEnabled() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().isEspEnabled();
    }

    public HDInsightLinkedService withIsEspEnabled(Object isEspEnabled) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withIsEspEnabled(isEspEnabled);
        return this;
    }

    public Object fileSystem() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fileSystem();
    }

    public HDInsightLinkedService withFileSystem(Object fileSystem) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFileSystem(fileSystem);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model HDInsightLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HDInsightLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightLinkedService)jsonReader.readObject(reader -> {
            HDInsightLinkedService deserializedHDInsightLinkedService = new HDInsightLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedHDInsightLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedHDInsightLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHDInsightLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedHDInsightLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedHDInsightLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedHDInsightLinkedService.innerTypeProperties = HDInsightLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHDInsightLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHDInsightLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedHDInsightLinkedService;
        });
    }
}

