/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.DelimitedTextReadSettings;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DelimitedTextSource
extends CopySource {
    private String type = "DelimitedTextSource";
    private StoreReadSettings storeSettings;
    private DelimitedTextReadSettings formatSettings;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public StoreReadSettings storeSettings() {
        return this.storeSettings;
    }

    public DelimitedTextSource withStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public DelimitedTextReadSettings formatSettings() {
        return this.formatSettings;
    }

    public DelimitedTextSource withFormatSettings(DelimitedTextReadSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public DelimitedTextSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public DelimitedTextSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public DelimitedTextSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public DelimitedTextSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public DelimitedTextSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.storeSettings() != null) {
            this.storeSettings().validate();
        }
        if (this.formatSettings() != null) {
            this.formatSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
        jsonWriter.writeJsonField("formatSettings", (JsonSerializable)this.formatSettings);
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DelimitedTextSource fromJson(JsonReader jsonReader) throws IOException {
        return (DelimitedTextSource)jsonReader.readObject(reader -> {
            DelimitedTextSource deserializedDelimitedTextSource = new DelimitedTextSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedDelimitedTextSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedDelimitedTextSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedDelimitedTextSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedDelimitedTextSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDelimitedTextSource.type = reader.getString();
                    continue;
                }
                if ("storeSettings".equals(fieldName)) {
                    deserializedDelimitedTextSource.storeSettings = StoreReadSettings.fromJson(reader);
                    continue;
                }
                if ("formatSettings".equals(fieldName)) {
                    deserializedDelimitedTextSource.formatSettings = DelimitedTextReadSettings.fromJson(reader);
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedDelimitedTextSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDelimitedTextSource.withAdditionalProperties(additionalProperties);
            return deserializedDelimitedTextSource;
        });
    }
}

