/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.DeleteActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.LogStorageSettings;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DeleteActivity
extends ExecutionActivity {
    private String type = "Delete";
    private DeleteActivityTypeProperties innerTypeProperties = new DeleteActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(DeleteActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    DeleteActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public DeleteActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DeleteActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public DeleteActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DeleteActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DeleteActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public DeleteActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public DeleteActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public DeleteActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object recursive() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().recursive();
    }

    public DeleteActivity withRecursive(Object recursive) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withRecursive(recursive);
        return this;
    }

    public Integer maxConcurrentConnections() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().maxConcurrentConnections();
    }

    public DeleteActivity withMaxConcurrentConnections(Integer maxConcurrentConnections) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    public Object enableLogging() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableLogging();
    }

    public DeleteActivity withEnableLogging(Object enableLogging) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withEnableLogging(enableLogging);
        return this;
    }

    public LogStorageSettings logStorageSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logStorageSettings();
    }

    public DeleteActivity withLogStorageSettings(LogStorageSettings logStorageSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withLogStorageSettings(logStorageSettings);
        return this;
    }

    public DatasetReference dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    public DeleteActivity withDataset(DatasetReference dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    public StoreReadSettings storeSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storeSettings();
    }

    public DeleteActivity withStoreSettings(StoreReadSettings storeSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DeleteActivityTypeProperties();
        }
        this.innerTypeProperties().withStoreSettings(storeSettings);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model DeleteActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DeleteActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DeleteActivity fromJson(JsonReader jsonReader) throws IOException {
        return (DeleteActivity)jsonReader.readObject(reader -> {
            DeleteActivity deserializedDeleteActivity = new DeleteActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDeleteActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDeleteActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDeleteActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedDeleteActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedDeleteActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedDeleteActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedDeleteActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedDeleteActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedDeleteActivity.innerTypeProperties = DeleteActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeleteActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDeleteActivity.withAdditionalProperties(additionalProperties);
            return deserializedDeleteActivity;
        });
    }
}

