/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.DataLakeAnalyticsUsqlActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DataLakeAnalyticsUsqlActivity
extends ExecutionActivity {
    private String type = "DataLakeAnalyticsU-SQL";
    private DataLakeAnalyticsUsqlActivityTypeProperties innerTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeAnalyticsUsqlActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    DataLakeAnalyticsUsqlActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object scriptPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scriptPath();
    }

    public DataLakeAnalyticsUsqlActivity withScriptPath(Object scriptPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
        }
        this.innerTypeProperties().withScriptPath(scriptPath);
        return this;
    }

    public LinkedServiceReference scriptLinkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scriptLinkedService();
    }

    public DataLakeAnalyticsUsqlActivity withScriptLinkedService(LinkedServiceReference scriptLinkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
        }
        this.innerTypeProperties().withScriptLinkedService(scriptLinkedService);
        return this;
    }

    public Object degreeOfParallelism() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().degreeOfParallelism();
    }

    public DataLakeAnalyticsUsqlActivity withDegreeOfParallelism(Object degreeOfParallelism) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
        }
        this.innerTypeProperties().withDegreeOfParallelism(degreeOfParallelism);
        return this;
    }

    public Object priority() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().priority();
    }

    public DataLakeAnalyticsUsqlActivity withPriority(Object priority) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
        }
        this.innerTypeProperties().withPriority(priority);
        return this;
    }

    public Map<String, Object> parameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parameters();
    }

    public DataLakeAnalyticsUsqlActivity withParameters(Map<String, Object> parameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
        }
        this.innerTypeProperties().withParameters(parameters);
        return this;
    }

    public Object runtimeVersion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().runtimeVersion();
    }

    public DataLakeAnalyticsUsqlActivity withRuntimeVersion(Object runtimeVersion) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
        }
        this.innerTypeProperties().withRuntimeVersion(runtimeVersion);
        return this;
    }

    public Object compilationMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compilationMode();
    }

    public DataLakeAnalyticsUsqlActivity withCompilationMode(Object compilationMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
        }
        this.innerTypeProperties().withCompilationMode(compilationMode);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model DataLakeAnalyticsUsqlActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DataLakeAnalyticsUsqlActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DataLakeAnalyticsUsqlActivity fromJson(JsonReader jsonReader) throws IOException {
        return (DataLakeAnalyticsUsqlActivity)jsonReader.readObject(reader -> {
            DataLakeAnalyticsUsqlActivity deserializedDataLakeAnalyticsUsqlActivity = new DataLakeAnalyticsUsqlActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedDataLakeAnalyticsUsqlActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedDataLakeAnalyticsUsqlActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.innerTypeProperties = DataLakeAnalyticsUsqlActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDataLakeAnalyticsUsqlActivity.withAdditionalProperties(additionalProperties);
            return deserializedDataLakeAnalyticsUsqlActivity;
        });
    }
}

