/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CosmosDbSqlApiSource
extends CopySource {
    private String type = "CosmosDbSqlApiSource";
    private Object query;
    private Object pageSize;
    private Object preferredRegions;
    private Object detectDatetime;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public CosmosDbSqlApiSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object pageSize() {
        return this.pageSize;
    }

    public CosmosDbSqlApiSource withPageSize(Object pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Object preferredRegions() {
        return this.preferredRegions;
    }

    public CosmosDbSqlApiSource withPreferredRegions(Object preferredRegions) {
        this.preferredRegions = preferredRegions;
        return this;
    }

    public Object detectDatetime() {
        return this.detectDatetime;
    }

    public CosmosDbSqlApiSource withDetectDatetime(Object detectDatetime) {
        this.detectDatetime = detectDatetime;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public CosmosDbSqlApiSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public CosmosDbSqlApiSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public CosmosDbSqlApiSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public CosmosDbSqlApiSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public CosmosDbSqlApiSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.pageSize != null) {
            jsonWriter.writeUntypedField("pageSize", this.pageSize);
        }
        if (this.preferredRegions != null) {
            jsonWriter.writeUntypedField("preferredRegions", this.preferredRegions);
        }
        if (this.detectDatetime != null) {
            jsonWriter.writeUntypedField("detectDatetime", this.detectDatetime);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CosmosDbSqlApiSource fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDbSqlApiSource)jsonReader.readObject(reader -> {
            CosmosDbSqlApiSource deserializedCosmosDbSqlApiSource = new CosmosDbSqlApiSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.query = reader.readUntyped();
                    continue;
                }
                if ("pageSize".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.pageSize = reader.readUntyped();
                    continue;
                }
                if ("preferredRegions".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.preferredRegions = reader.readUntyped();
                    continue;
                }
                if ("detectDatetime".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.detectDatetime = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCosmosDbSqlApiSource.withAdditionalProperties(additionalProperties);
            return deserializedCosmosDbSqlApiSource;
        });
    }
}

