/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.AppendVariableActivity;
import com.azure.resourcemanager.datafactory.models.ExecutePipelineActivity;
import com.azure.resourcemanager.datafactory.models.FailActivity;
import com.azure.resourcemanager.datafactory.models.FilterActivity;
import com.azure.resourcemanager.datafactory.models.ForEachActivity;
import com.azure.resourcemanager.datafactory.models.IfConditionActivity;
import com.azure.resourcemanager.datafactory.models.SetVariableActivity;
import com.azure.resourcemanager.datafactory.models.SwitchActivity;
import com.azure.resourcemanager.datafactory.models.UntilActivity;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.azure.resourcemanager.datafactory.models.ValidationActivity;
import com.azure.resourcemanager.datafactory.models.WaitActivity;
import com.azure.resourcemanager.datafactory.models.WebhookActivity;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ControlActivity
extends Activity {
    private String type = "Container";
    private static final ClientLogger LOGGER = new ClientLogger(ControlActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public ControlActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ControlActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ControlActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public ControlActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ControlActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    @Override
    public ControlActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    @Override
    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ControlActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ControlActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ControlActivity)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ControlActivity controlActivity;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ExecutePipeline".equals(discriminatorValue)) {
                    controlActivity = ExecutePipelineActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("IfCondition".equals(discriminatorValue)) {
                    controlActivity = IfConditionActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Switch".equals(discriminatorValue)) {
                    controlActivity = SwitchActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("ForEach".equals(discriminatorValue)) {
                    controlActivity = ForEachActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Wait".equals(discriminatorValue)) {
                    controlActivity = WaitActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Fail".equals(discriminatorValue)) {
                    controlActivity = FailActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Until".equals(discriminatorValue)) {
                    controlActivity = UntilActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Validation".equals(discriminatorValue)) {
                    controlActivity = ValidationActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Filter".equals(discriminatorValue)) {
                    controlActivity = FilterActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("SetVariable".equals(discriminatorValue)) {
                    controlActivity = SetVariableActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("AppendVariable".equals(discriminatorValue)) {
                    controlActivity = AppendVariableActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("WebHook".equals(discriminatorValue)) {
                    controlActivity = WebhookActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                controlActivity = ControlActivity.fromJsonKnownDiscriminator(readerToUse.reset());
                return controlActivity;
            }
        });
    }

    static ControlActivity fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ControlActivity)jsonReader.readObject(reader -> {
            ControlActivity deserializedControlActivity = new ControlActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedControlActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedControlActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedControlActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedControlActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedControlActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedControlActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedControlActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedControlActivity.withAdditionalProperties(additionalProperties);
            return deserializedControlActivity;
        });
    }
}

