/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.CmdkeySetupTypeProperties;
import com.azure.resourcemanager.datafactory.models.CustomSetupBase;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class CmdkeySetup
extends CustomSetupBase {
    private String type = "CmdkeySetup";
    private CmdkeySetupTypeProperties innerTypeProperties = new CmdkeySetupTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(CmdkeySetup.class);

    @Override
    public String type() {
        return this.type;
    }

    CmdkeySetupTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public Object targetName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().targetName();
    }

    public CmdkeySetup withTargetName(Object targetName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CmdkeySetupTypeProperties();
        }
        this.innerTypeProperties().withTargetName(targetName);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public CmdkeySetup withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CmdkeySetupTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public CmdkeySetup withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CmdkeySetupTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model CmdkeySetup"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static CmdkeySetup fromJson(JsonReader jsonReader) throws IOException {
        return (CmdkeySetup)jsonReader.readObject(reader -> {
            CmdkeySetup deserializedCmdkeySetup = new CmdkeySetup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("typeProperties".equals(fieldName)) {
                    deserializedCmdkeySetup.innerTypeProperties = CmdkeySetupTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCmdkeySetup.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCmdkeySetup;
        });
    }
}

