/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BlobSource
extends CopySource {
    private String type = "BlobSource";
    private Object treatEmptyAsNull;
    private Object skipHeaderLineCount;
    private Object recursive;

    @Override
    public String type() {
        return this.type;
    }

    public Object treatEmptyAsNull() {
        return this.treatEmptyAsNull;
    }

    public BlobSource withTreatEmptyAsNull(Object treatEmptyAsNull) {
        this.treatEmptyAsNull = treatEmptyAsNull;
        return this;
    }

    public Object skipHeaderLineCount() {
        return this.skipHeaderLineCount;
    }

    public BlobSource withSkipHeaderLineCount(Object skipHeaderLineCount) {
        this.skipHeaderLineCount = skipHeaderLineCount;
        return this;
    }

    public Object recursive() {
        return this.recursive;
    }

    public BlobSource withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    @Override
    public BlobSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public BlobSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public BlobSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public BlobSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.treatEmptyAsNull != null) {
            jsonWriter.writeUntypedField("treatEmptyAsNull", this.treatEmptyAsNull);
        }
        if (this.skipHeaderLineCount != null) {
            jsonWriter.writeUntypedField("skipHeaderLineCount", this.skipHeaderLineCount);
        }
        if (this.recursive != null) {
            jsonWriter.writeUntypedField("recursive", this.recursive);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BlobSource fromJson(JsonReader jsonReader) throws IOException {
        return (BlobSource)jsonReader.readObject(reader -> {
            BlobSource deserializedBlobSource = new BlobSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedBlobSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedBlobSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedBlobSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedBlobSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobSource.type = reader.getString();
                    continue;
                }
                if ("treatEmptyAsNull".equals(fieldName)) {
                    deserializedBlobSource.treatEmptyAsNull = reader.readUntyped();
                    continue;
                }
                if ("skipHeaderLineCount".equals(fieldName)) {
                    deserializedBlobSource.skipHeaderLineCount = reader.readUntyped();
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedBlobSource.recursive = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBlobSource.withAdditionalProperties(additionalProperties);
            return deserializedBlobSource;
        });
    }
}

