/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureDatabricksDeltaLakeDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureDatabricksDeltaLakeDataset
extends Dataset {
    private String type = "AzureDatabricksDeltaLakeDataset";
    private AzureDatabricksDeltaLakeDatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(AzureDatabricksDeltaLakeDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureDatabricksDeltaLakeDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object table() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().table();
    }

    public AzureDatabricksDeltaLakeDataset withTable(Object table) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksDeltaLakeDatasetTypeProperties();
        }
        this.innerTypeProperties().withTable(table);
        return this;
    }

    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    public AzureDatabricksDeltaLakeDataset withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDatabricksDeltaLakeDatasetTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model AzureDatabricksDeltaLakeDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        if (this.structure() != null) {
            jsonWriter.writeUntypedField("structure", this.structure());
        }
        if (this.schema() != null) {
            jsonWriter.writeUntypedField("schema", this.schema());
        }
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksDeltaLakeDataset fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksDeltaLakeDataset)jsonReader.readObject(reader -> {
            AzureDatabricksDeltaLakeDataset deserializedAzureDatabricksDeltaLakeDataset = new AzureDatabricksDeltaLakeDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDatabricksDeltaLakeDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDatabricksDeltaLakeDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.innerTypeProperties = AzureDatabricksDeltaLakeDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksDeltaLakeDataset.withAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksDeltaLakeDataset;
        });
    }
}

