/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureDataExplorerCommandActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureDataExplorerCommandActivity
extends ExecutionActivity {
    private String type = "AzureDataExplorerCommand";
    private AzureDataExplorerCommandActivityTypeProperties innerTypeProperties = new AzureDataExplorerCommandActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureDataExplorerCommandActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureDataExplorerCommandActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureDataExplorerCommandActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureDataExplorerCommandActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public AzureDataExplorerCommandActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public AzureDataExplorerCommandActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureDataExplorerCommandActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public AzureDataExplorerCommandActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public AzureDataExplorerCommandActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureDataExplorerCommandActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object command() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().command();
    }

    public AzureDataExplorerCommandActivity withCommand(Object command) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataExplorerCommandActivityTypeProperties();
        }
        this.innerTypeProperties().withCommand(command);
        return this;
    }

    public Object commandTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandTimeout();
    }

    public AzureDataExplorerCommandActivity withCommandTimeout(Object commandTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataExplorerCommandActivityTypeProperties();
        }
        this.innerTypeProperties().withCommandTimeout(commandTimeout);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureDataExplorerCommandActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model AzureDataExplorerCommandActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataExplorerCommandActivity fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataExplorerCommandActivity)jsonReader.readObject(reader -> {
            AzureDataExplorerCommandActivity deserializedAzureDataExplorerCommandActivity = new AzureDataExplorerCommandActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureDataExplorerCommandActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDataExplorerCommandActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAzureDataExplorerCommandActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedAzureDataExplorerCommandActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedAzureDataExplorerCommandActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedAzureDataExplorerCommandActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureDataExplorerCommandActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedAzureDataExplorerCommandActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureDataExplorerCommandActivity.innerTypeProperties = AzureDataExplorerCommandActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataExplorerCommandActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataExplorerCommandActivity.withAdditionalProperties(additionalProperties);
            return deserializedAzureDataExplorerCommandActivity;
        });
    }
}

