/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureBlobStorageReadSettings
extends StoreReadSettings {
    private String type = "AzureBlobStorageReadSettings";
    private Object recursive;
    private Object wildcardFolderPath;
    private Object wildcardFileName;
    private Object prefix;
    private Object fileListPath;
    private Object enablePartitionDiscovery;
    private Object partitionRootPath;
    private Object deleteFilesAfterCompletion;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;

    @Override
    public String type() {
        return this.type;
    }

    public Object recursive() {
        return this.recursive;
    }

    public AzureBlobStorageReadSettings withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    public Object wildcardFolderPath() {
        return this.wildcardFolderPath;
    }

    public AzureBlobStorageReadSettings withWildcardFolderPath(Object wildcardFolderPath) {
        this.wildcardFolderPath = wildcardFolderPath;
        return this;
    }

    public Object wildcardFileName() {
        return this.wildcardFileName;
    }

    public AzureBlobStorageReadSettings withWildcardFileName(Object wildcardFileName) {
        this.wildcardFileName = wildcardFileName;
        return this;
    }

    public Object prefix() {
        return this.prefix;
    }

    public AzureBlobStorageReadSettings withPrefix(Object prefix) {
        this.prefix = prefix;
        return this;
    }

    public Object fileListPath() {
        return this.fileListPath;
    }

    public AzureBlobStorageReadSettings withFileListPath(Object fileListPath) {
        this.fileListPath = fileListPath;
        return this;
    }

    public Object enablePartitionDiscovery() {
        return this.enablePartitionDiscovery;
    }

    public AzureBlobStorageReadSettings withEnablePartitionDiscovery(Object enablePartitionDiscovery) {
        this.enablePartitionDiscovery = enablePartitionDiscovery;
        return this;
    }

    public Object partitionRootPath() {
        return this.partitionRootPath;
    }

    public AzureBlobStorageReadSettings withPartitionRootPath(Object partitionRootPath) {
        this.partitionRootPath = partitionRootPath;
        return this;
    }

    public Object deleteFilesAfterCompletion() {
        return this.deleteFilesAfterCompletion;
    }

    public AzureBlobStorageReadSettings withDeleteFilesAfterCompletion(Object deleteFilesAfterCompletion) {
        this.deleteFilesAfterCompletion = deleteFilesAfterCompletion;
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public AzureBlobStorageReadSettings withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public AzureBlobStorageReadSettings withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    @Override
    public AzureBlobStorageReadSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureBlobStorageReadSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.recursive != null) {
            jsonWriter.writeUntypedField("recursive", this.recursive);
        }
        if (this.wildcardFolderPath != null) {
            jsonWriter.writeUntypedField("wildcardFolderPath", this.wildcardFolderPath);
        }
        if (this.wildcardFileName != null) {
            jsonWriter.writeUntypedField("wildcardFileName", this.wildcardFileName);
        }
        if (this.prefix != null) {
            jsonWriter.writeUntypedField("prefix", this.prefix);
        }
        if (this.fileListPath != null) {
            jsonWriter.writeUntypedField("fileListPath", this.fileListPath);
        }
        if (this.enablePartitionDiscovery != null) {
            jsonWriter.writeUntypedField("enablePartitionDiscovery", this.enablePartitionDiscovery);
        }
        if (this.partitionRootPath != null) {
            jsonWriter.writeUntypedField("partitionRootPath", this.partitionRootPath);
        }
        if (this.deleteFilesAfterCompletion != null) {
            jsonWriter.writeUntypedField("deleteFilesAfterCompletion", this.deleteFilesAfterCompletion);
        }
        if (this.modifiedDatetimeStart != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
        }
        if (this.modifiedDatetimeEnd != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobStorageReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobStorageReadSettings)jsonReader.readObject(reader -> {
            AzureBlobStorageReadSettings deserializedAzureBlobStorageReadSettings = new AzureBlobStorageReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.type = reader.getString();
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.recursive = reader.readUntyped();
                    continue;
                }
                if ("wildcardFolderPath".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.wildcardFolderPath = reader.readUntyped();
                    continue;
                }
                if ("wildcardFileName".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.wildcardFileName = reader.readUntyped();
                    continue;
                }
                if ("prefix".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.prefix = reader.readUntyped();
                    continue;
                }
                if ("fileListPath".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.fileListPath = reader.readUntyped();
                    continue;
                }
                if ("enablePartitionDiscovery".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.enablePartitionDiscovery = reader.readUntyped();
                    continue;
                }
                if ("partitionRootPath".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.partitionRootPath = reader.readUntyped();
                    continue;
                }
                if ("deleteFilesAfterCompletion".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.deleteFilesAfterCompletion = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeStart".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.modifiedDatetimeStart = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeEnd".equals(fieldName)) {
                    deserializedAzureBlobStorageReadSettings.modifiedDatetimeEnd = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobStorageReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedAzureBlobStorageReadSettings;
        });
    }
}

