/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.LinkedServicesClient;
import com.azure.resourcemanager.datafactory.fluent.models.LinkedServiceResourceInner;
import com.azure.resourcemanager.datafactory.implementation.LinkedServiceResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.LinkedServiceResource;
import com.azure.resourcemanager.datafactory.models.LinkedServices;

public final class LinkedServicesImpl
implements LinkedServices {
    private static final ClientLogger LOGGER = new ClientLogger(LinkedServicesImpl.class);
    private final LinkedServicesClient innerClient;
    private final DataFactoryManager serviceManager;

    public LinkedServicesImpl(LinkedServicesClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LinkedServiceResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<LinkedServiceResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LinkedServiceResourceImpl((LinkedServiceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LinkedServiceResource> listByFactory(String resourceGroupName, String factoryName, Context context) {
        PagedIterable<LinkedServiceResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LinkedServiceResourceImpl((LinkedServiceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<LinkedServiceResource> getWithResponse(String resourceGroupName, String factoryName, String linkedServiceName, String ifNoneMatch, Context context) {
        Response<LinkedServiceResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, linkedServiceName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LinkedServiceResourceImpl((LinkedServiceResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public LinkedServiceResource get(String resourceGroupName, String factoryName, String linkedServiceName) {
        LinkedServiceResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, linkedServiceName);
        if (inner != null) {
            return new LinkedServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String linkedServiceName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, linkedServiceName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String linkedServiceName) {
        this.serviceClient().delete(resourceGroupName, factoryName, linkedServiceName);
    }

    @Override
    public LinkedServiceResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String linkedServiceName = ResourceManagerUtils.getValueFromIdByName(id, "linkedservices");
        if (linkedServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedservices'.", id)));
        }
        String localIfNoneMatch = null;
        return (LinkedServiceResource)this.getWithResponse(resourceGroupName, factoryName, linkedServiceName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<LinkedServiceResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String linkedServiceName = ResourceManagerUtils.getValueFromIdByName(id, "linkedservices");
        if (linkedServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedservices'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, linkedServiceName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String linkedServiceName = ResourceManagerUtils.getValueFromIdByName(id, "linkedservices");
        if (linkedServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedservices'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, linkedServiceName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String linkedServiceName = ResourceManagerUtils.getValueFromIdByName(id, "linkedservices");
        if (linkedServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedservices'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, linkedServiceName, context);
    }

    private LinkedServicesClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public LinkedServiceResourceImpl define(String name) {
        return new LinkedServiceResourceImpl(name, this.manager());
    }
}

