/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.ActivityRunsClient;
import com.azure.resourcemanager.datafactory.fluent.models.ActivityRunsQueryResponseInner;
import com.azure.resourcemanager.datafactory.implementation.ActivityRunsQueryResponseImpl;
import com.azure.resourcemanager.datafactory.models.ActivityRuns;
import com.azure.resourcemanager.datafactory.models.ActivityRunsQueryResponse;
import com.azure.resourcemanager.datafactory.models.RunFilterParameters;

public final class ActivityRunsImpl
implements ActivityRuns {
    private static final ClientLogger LOGGER = new ClientLogger(ActivityRunsImpl.class);
    private final ActivityRunsClient innerClient;
    private final DataFactoryManager serviceManager;

    public ActivityRunsImpl(ActivityRunsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ActivityRunsQueryResponse> queryByPipelineRunWithResponse(String resourceGroupName, String factoryName, String runId, RunFilterParameters filterParameters, Context context) {
        Response<ActivityRunsQueryResponseInner> inner = this.serviceClient().queryByPipelineRunWithResponse(resourceGroupName, factoryName, runId, filterParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ActivityRunsQueryResponseImpl((ActivityRunsQueryResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ActivityRunsQueryResponse queryByPipelineRun(String resourceGroupName, String factoryName, String runId, RunFilterParameters filterParameters) {
        ActivityRunsQueryResponseInner inner = this.serviceClient().queryByPipelineRun(resourceGroupName, factoryName, runId, filterParameters);
        if (inner != null) {
            return new ActivityRunsQueryResponseImpl(inner, this.manager());
        }
        return null;
    }

    private ActivityRunsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }
}

