/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SsisAccessCredential;
import java.io.IOException;

public final class SsisLogLocationTypeProperties
implements JsonSerializable<SsisLogLocationTypeProperties> {
    private SsisAccessCredential accessCredential;
    private Object logRefreshInterval;

    public SsisAccessCredential accessCredential() {
        return this.accessCredential;
    }

    public SsisLogLocationTypeProperties withAccessCredential(SsisAccessCredential accessCredential) {
        this.accessCredential = accessCredential;
        return this;
    }

    public Object logRefreshInterval() {
        return this.logRefreshInterval;
    }

    public SsisLogLocationTypeProperties withLogRefreshInterval(Object logRefreshInterval) {
        this.logRefreshInterval = logRefreshInterval;
        return this;
    }

    public void validate() {
        if (this.accessCredential() != null) {
            this.accessCredential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("accessCredential", (JsonSerializable)this.accessCredential);
        if (this.logRefreshInterval != null) {
            jsonWriter.writeUntypedField("logRefreshInterval", this.logRefreshInterval);
        }
        return jsonWriter.writeEndObject();
    }

    public static SsisLogLocationTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SsisLogLocationTypeProperties)jsonReader.readObject(reader -> {
            SsisLogLocationTypeProperties deserializedSsisLogLocationTypeProperties = new SsisLogLocationTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessCredential".equals(fieldName)) {
                    deserializedSsisLogLocationTypeProperties.accessCredential = SsisAccessCredential.fromJson(reader);
                    continue;
                }
                if ("logRefreshInterval".equals(fieldName)) {
                    deserializedSsisLogLocationTypeProperties.logRefreshInterval = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisLogLocationTypeProperties;
        });
    }
}

