/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class SnowflakeLinkedServiceTypeProperties
implements JsonSerializable<SnowflakeLinkedServiceTypeProperties> {
    private Object connectionString;
    private AzureKeyVaultSecretReference password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(SnowflakeLinkedServiceTypeProperties.class);

    public Object connectionString() {
        return this.connectionString;
    }

    public SnowflakeLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    public SnowflakeLinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SnowflakeLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model SnowflakeLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SnowflakeLinkedServiceTypeProperties deserializedSnowflakeLinkedServiceTypeProperties = new SnowflakeLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedSnowflakeLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSnowflakeLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSnowflakeLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnowflakeLinkedServiceTypeProperties;
        });
    }
}

