/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SalesforceV2LinkedServiceTypeProperties
implements JsonSerializable<SalesforceV2LinkedServiceTypeProperties> {
    private Object environmentUrl;
    private Object authenticationType;
    private Object clientId;
    private SecretBase clientSecret;
    private Object apiVersion;
    private String encryptedCredential;

    public Object environmentUrl() {
        return this.environmentUrl;
    }

    public SalesforceV2LinkedServiceTypeProperties withEnvironmentUrl(Object environmentUrl) {
        this.environmentUrl = environmentUrl;
        return this;
    }

    public Object authenticationType() {
        return this.authenticationType;
    }

    public SalesforceV2LinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public SalesforceV2LinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public SalesforceV2LinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object apiVersion() {
        return this.apiVersion;
    }

    public SalesforceV2LinkedServiceTypeProperties withApiVersion(Object apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SalesforceV2LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.environmentUrl != null) {
            jsonWriter.writeUntypedField("environmentUrl", this.environmentUrl);
        }
        if (this.authenticationType != null) {
            jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        }
        if (this.clientId != null) {
            jsonWriter.writeUntypedField("clientId", this.clientId);
        }
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        if (this.apiVersion != null) {
            jsonWriter.writeUntypedField("apiVersion", this.apiVersion);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SalesforceV2LinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceV2LinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            SalesforceV2LinkedServiceTypeProperties deserializedSalesforceV2LinkedServiceTypeProperties = new SalesforceV2LinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("environmentUrl".equals(fieldName)) {
                    deserializedSalesforceV2LinkedServiceTypeProperties.environmentUrl = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedSalesforceV2LinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedSalesforceV2LinkedServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedSalesforceV2LinkedServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedSalesforceV2LinkedServiceTypeProperties.apiVersion = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSalesforceV2LinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSalesforceV2LinkedServiceTypeProperties;
        });
    }
}

