/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class QuickbaseLinkedServiceTypeProperties
implements JsonSerializable<QuickbaseLinkedServiceTypeProperties> {
    private Object url;
    private SecretBase userToken;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(QuickbaseLinkedServiceTypeProperties.class);

    public Object url() {
        return this.url;
    }

    public QuickbaseLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public SecretBase userToken() {
        return this.userToken;
    }

    public QuickbaseLinkedServiceTypeProperties withUserToken(SecretBase userToken) {
        this.userToken = userToken;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public QuickbaseLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model QuickbaseLinkedServiceTypeProperties"));
        }
        if (this.userToken() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property userToken in model QuickbaseLinkedServiceTypeProperties"));
        }
        this.userToken().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeJsonField("userToken", (JsonSerializable)this.userToken);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static QuickbaseLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (QuickbaseLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            QuickbaseLinkedServiceTypeProperties deserializedQuickbaseLinkedServiceTypeProperties = new QuickbaseLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedQuickbaseLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("userToken".equals(fieldName)) {
                    deserializedQuickbaseLinkedServiceTypeProperties.userToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedQuickbaseLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuickbaseLinkedServiceTypeProperties;
        });
    }
}

