/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Office365DatasetTypeProperties
implements JsonSerializable<Office365DatasetTypeProperties> {
    private Object tableName;
    private Object predicate;
    private static final ClientLogger LOGGER = new ClientLogger(Office365DatasetTypeProperties.class);

    public Object tableName() {
        return this.tableName;
    }

    public Office365DatasetTypeProperties withTableName(Object tableName) {
        this.tableName = tableName;
        return this;
    }

    public Object predicate() {
        return this.predicate;
    }

    public Office365DatasetTypeProperties withPredicate(Object predicate) {
        this.predicate = predicate;
        return this;
    }

    public void validate() {
        if (this.tableName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tableName in model Office365DatasetTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("tableName", this.tableName);
        if (this.predicate != null) {
            jsonWriter.writeUntypedField("predicate", this.predicate);
        }
        return jsonWriter.writeEndObject();
    }

    public static Office365DatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (Office365DatasetTypeProperties)jsonReader.readObject(reader -> {
            Office365DatasetTypeProperties deserializedOffice365DatasetTypeProperties = new Office365DatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tableName".equals(fieldName)) {
                    deserializedOffice365DatasetTypeProperties.tableName = reader.readUntyped();
                    continue;
                }
                if ("predicate".equals(fieldName)) {
                    deserializedOffice365DatasetTypeProperties.predicate = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOffice365DatasetTypeProperties;
        });
    }
}

