/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MapperDslConnectorProperties;
import com.azure.resourcemanager.datafactory.models.MapperTableSchema;
import java.io.IOException;
import java.util.List;

public final class MapperTableProperties
implements JsonSerializable<MapperTableProperties> {
    private List<MapperTableSchema> schema;
    private List<MapperDslConnectorProperties> dslConnectorProperties;

    public List<MapperTableSchema> schema() {
        return this.schema;
    }

    public MapperTableProperties withSchema(List<MapperTableSchema> schema) {
        this.schema = schema;
        return this;
    }

    public List<MapperDslConnectorProperties> dslConnectorProperties() {
        return this.dslConnectorProperties;
    }

    public MapperTableProperties withDslConnectorProperties(List<MapperDslConnectorProperties> dslConnectorProperties) {
        this.dslConnectorProperties = dslConnectorProperties;
        return this;
    }

    public void validate() {
        if (this.schema() != null) {
            this.schema().forEach(e -> e.validate());
        }
        if (this.dslConnectorProperties() != null) {
            this.dslConnectorProperties().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("schema", this.schema, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dslConnectorProperties", this.dslConnectorProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MapperTableProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MapperTableProperties)jsonReader.readObject(reader -> {
            MapperTableProperties deserializedMapperTableProperties = new MapperTableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schema".equals(fieldName)) {
                    List schema;
                    deserializedMapperTableProperties.schema = schema = reader.readArray(reader1 -> MapperTableSchema.fromJson(reader1));
                    continue;
                }
                if ("dslConnectorProperties".equals(fieldName)) {
                    List dslConnectorProperties;
                    deserializedMapperTableProperties.dslConnectorProperties = dslConnectorProperties = reader.readArray(reader1 -> MapperDslConnectorProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperTableProperties;
        });
    }
}

