/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HDInsightStreamingActivityTypeProperties
implements JsonSerializable<HDInsightStreamingActivityTypeProperties> {
    private List<LinkedServiceReference> storageLinkedServices;
    private List<Object> arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private Object mapper;
    private Object reducer;
    private Object input;
    private Object output;
    private List<Object> filePaths;
    private LinkedServiceReference fileLinkedService;
    private Object combiner;
    private List<Object> commandEnvironment;
    private Map<String, Object> defines;
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightStreamingActivityTypeProperties.class);

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightStreamingActivityTypeProperties withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public List<Object> arguments() {
        return this.arguments;
    }

    public HDInsightStreamingActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightStreamingActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object mapper() {
        return this.mapper;
    }

    public HDInsightStreamingActivityTypeProperties withMapper(Object mapper) {
        this.mapper = mapper;
        return this;
    }

    public Object reducer() {
        return this.reducer;
    }

    public HDInsightStreamingActivityTypeProperties withReducer(Object reducer) {
        this.reducer = reducer;
        return this;
    }

    public Object input() {
        return this.input;
    }

    public HDInsightStreamingActivityTypeProperties withInput(Object input) {
        this.input = input;
        return this;
    }

    public Object output() {
        return this.output;
    }

    public HDInsightStreamingActivityTypeProperties withOutput(Object output) {
        this.output = output;
        return this;
    }

    public List<Object> filePaths() {
        return this.filePaths;
    }

    public HDInsightStreamingActivityTypeProperties withFilePaths(List<Object> filePaths) {
        this.filePaths = filePaths;
        return this;
    }

    public LinkedServiceReference fileLinkedService() {
        return this.fileLinkedService;
    }

    public HDInsightStreamingActivityTypeProperties withFileLinkedService(LinkedServiceReference fileLinkedService) {
        this.fileLinkedService = fileLinkedService;
        return this;
    }

    public Object combiner() {
        return this.combiner;
    }

    public HDInsightStreamingActivityTypeProperties withCombiner(Object combiner) {
        this.combiner = combiner;
        return this;
    }

    public List<Object> commandEnvironment() {
        return this.commandEnvironment;
    }

    public HDInsightStreamingActivityTypeProperties withCommandEnvironment(List<Object> commandEnvironment) {
        this.commandEnvironment = commandEnvironment;
        return this;
    }

    public Map<String, Object> defines() {
        return this.defines;
    }

    public HDInsightStreamingActivityTypeProperties withDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    public void validate() {
        if (this.storageLinkedServices() != null) {
            this.storageLinkedServices().forEach(e -> e.validate());
        }
        if (this.mapper() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mapper in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.reducer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property reducer in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.input() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property input in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.output() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property output in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.filePaths() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filePaths in model HDInsightStreamingActivityTypeProperties"));
        }
        if (this.fileLinkedService() != null) {
            this.fileLinkedService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("mapper", this.mapper);
        jsonWriter.writeUntypedField("reducer", this.reducer);
        jsonWriter.writeUntypedField("input", this.input);
        jsonWriter.writeUntypedField("output", this.output);
        jsonWriter.writeArrayField("filePaths", this.filePaths, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("storageLinkedServices", this.storageLinkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
        jsonWriter.writeJsonField("fileLinkedService", (JsonSerializable)this.fileLinkedService);
        if (this.combiner != null) {
            jsonWriter.writeUntypedField("combiner", this.combiner);
        }
        jsonWriter.writeArrayField("commandEnvironment", this.commandEnvironment, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("defines", this.defines, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static HDInsightStreamingActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightStreamingActivityTypeProperties)jsonReader.readObject(reader -> {
            HDInsightStreamingActivityTypeProperties deserializedHDInsightStreamingActivityTypeProperties = new HDInsightStreamingActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mapper".equals(fieldName)) {
                    deserializedHDInsightStreamingActivityTypeProperties.mapper = reader.readUntyped();
                    continue;
                }
                if ("reducer".equals(fieldName)) {
                    deserializedHDInsightStreamingActivityTypeProperties.reducer = reader.readUntyped();
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedHDInsightStreamingActivityTypeProperties.input = reader.readUntyped();
                    continue;
                }
                if ("output".equals(fieldName)) {
                    deserializedHDInsightStreamingActivityTypeProperties.output = reader.readUntyped();
                    continue;
                }
                if ("filePaths".equals(fieldName)) {
                    List filePaths;
                    deserializedHDInsightStreamingActivityTypeProperties.filePaths = filePaths = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("storageLinkedServices".equals(fieldName)) {
                    List storageLinkedServices;
                    deserializedHDInsightStreamingActivityTypeProperties.storageLinkedServices = storageLinkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List arguments;
                    deserializedHDInsightStreamingActivityTypeProperties.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("getDebugInfo".equals(fieldName)) {
                    deserializedHDInsightStreamingActivityTypeProperties.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                    continue;
                }
                if ("fileLinkedService".equals(fieldName)) {
                    deserializedHDInsightStreamingActivityTypeProperties.fileLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("combiner".equals(fieldName)) {
                    deserializedHDInsightStreamingActivityTypeProperties.combiner = reader.readUntyped();
                    continue;
                }
                if ("commandEnvironment".equals(fieldName)) {
                    List commandEnvironment;
                    deserializedHDInsightStreamingActivityTypeProperties.commandEnvironment = commandEnvironment = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("defines".equals(fieldName)) {
                    Map defines;
                    deserializedHDInsightStreamingActivityTypeProperties.defines = defines = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHDInsightStreamingActivityTypeProperties;
        });
    }
}

