/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FtpAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class FtpServerLinkedServiceTypeProperties
implements JsonSerializable<FtpServerLinkedServiceTypeProperties> {
    private Object host;
    private Object port;
    private FtpAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private Object enableSsl;
    private Object enableServerCertificateValidation;
    private static final ClientLogger LOGGER = new ClientLogger(FtpServerLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public FtpServerLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public FtpServerLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public FtpAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public FtpServerLinkedServiceTypeProperties withAuthenticationType(FtpAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public FtpServerLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public FtpServerLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public FtpServerLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object enableSsl() {
        return this.enableSsl;
    }

    public FtpServerLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object enableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public FtpServerLinkedServiceTypeProperties withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model FtpServerLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.username != null) {
            jsonWriter.writeUntypedField("userName", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        if (this.enableSsl != null) {
            jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
        }
        if (this.enableServerCertificateValidation != null) {
            jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
        }
        return jsonWriter.writeEndObject();
    }

    public static FtpServerLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FtpServerLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            FtpServerLinkedServiceTypeProperties deserializedFtpServerLinkedServiceTypeProperties = new FtpServerLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedFtpServerLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedFtpServerLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedFtpServerLinkedServiceTypeProperties.authenticationType = FtpAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedFtpServerLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedFtpServerLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedFtpServerLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("enableSsl".equals(fieldName)) {
                    deserializedFtpServerLinkedServiceTypeProperties.enableSsl = reader.readUntyped();
                    continue;
                }
                if ("enableServerCertificateValidation".equals(fieldName)) {
                    deserializedFtpServerLinkedServiceTypeProperties.enableServerCertificateValidation = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFtpServerLinkedServiceTypeProperties;
        });
    }
}

