/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import java.io.IOException;

public final class FileShareDatasetTypeProperties
implements JsonSerializable<FileShareDatasetTypeProperties> {
    private Object folderPath;
    private Object fileName;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;
    private DatasetStorageFormat format;
    private Object fileFilter;
    private DatasetCompression compression;

    public Object folderPath() {
        return this.folderPath;
    }

    public FileShareDatasetTypeProperties withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Object fileName() {
        return this.fileName;
    }

    public FileShareDatasetTypeProperties withFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public FileShareDatasetTypeProperties withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public FileShareDatasetTypeProperties withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    public DatasetStorageFormat format() {
        return this.format;
    }

    public FileShareDatasetTypeProperties withFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public Object fileFilter() {
        return this.fileFilter;
    }

    public FileShareDatasetTypeProperties withFileFilter(Object fileFilter) {
        this.fileFilter = fileFilter;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public FileShareDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public void validate() {
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.folderPath != null) {
            jsonWriter.writeUntypedField("folderPath", this.folderPath);
        }
        if (this.fileName != null) {
            jsonWriter.writeUntypedField("fileName", this.fileName);
        }
        if (this.modifiedDatetimeStart != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
        }
        if (this.modifiedDatetimeEnd != null) {
            jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
        }
        jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
        if (this.fileFilter != null) {
            jsonWriter.writeUntypedField("fileFilter", this.fileFilter);
        }
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        return jsonWriter.writeEndObject();
    }

    public static FileShareDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FileShareDatasetTypeProperties)jsonReader.readObject(reader -> {
            FileShareDatasetTypeProperties deserializedFileShareDatasetTypeProperties = new FileShareDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedFileShareDatasetTypeProperties.folderPath = reader.readUntyped();
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedFileShareDatasetTypeProperties.fileName = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeStart".equals(fieldName)) {
                    deserializedFileShareDatasetTypeProperties.modifiedDatetimeStart = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeEnd".equals(fieldName)) {
                    deserializedFileShareDatasetTypeProperties.modifiedDatetimeEnd = reader.readUntyped();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedFileShareDatasetTypeProperties.format = DatasetStorageFormat.fromJson(reader);
                    continue;
                }
                if ("fileFilter".equals(fieldName)) {
                    deserializedFileShareDatasetTypeProperties.fileFilter = reader.readUntyped();
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedFileShareDatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileShareDatasetTypeProperties;
        });
    }
}

