/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ExecuteDataFlowActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ContinuationSettingsReference;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DataFlowStagingInfo;
import com.azure.resourcemanager.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.PowerQuerySink;
import com.azure.resourcemanager.datafactory.models.PowerQuerySinkMapping;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExecutePowerQueryActivityTypeProperties
extends ExecuteDataFlowActivityTypeProperties {
    private Map<String, PowerQuerySink> sinks;
    private List<PowerQuerySinkMapping> queries;
    private static final ClientLogger LOGGER = new ClientLogger(ExecutePowerQueryActivityTypeProperties.class);

    public Map<String, PowerQuerySink> sinks() {
        return this.sinks;
    }

    public ExecutePowerQueryActivityTypeProperties withSinks(Map<String, PowerQuerySink> sinks) {
        this.sinks = sinks;
        return this;
    }

    public List<PowerQuerySinkMapping> queries() {
        return this.queries;
    }

    public ExecutePowerQueryActivityTypeProperties withQueries(List<PowerQuerySinkMapping> queries) {
        this.queries = queries;
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withDataFlow(DataFlowReference dataFlow) {
        super.withDataFlow(dataFlow);
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withStaging(DataFlowStagingInfo staging) {
        super.withStaging(staging);
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withIntegrationRuntime(IntegrationRuntimeReference integrationRuntime) {
        super.withIntegrationRuntime(integrationRuntime);
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withContinuationSettings(ContinuationSettingsReference continuationSettings) {
        super.withContinuationSettings(continuationSettings);
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withCompute(ExecuteDataFlowActivityTypePropertiesCompute compute) {
        super.withCompute(compute);
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withTraceLevel(Object traceLevel) {
        super.withTraceLevel(traceLevel);
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withContinueOnError(Object continueOnError) {
        super.withContinueOnError(continueOnError);
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withRunConcurrently(Object runConcurrently) {
        super.withRunConcurrently(runConcurrently);
        return this;
    }

    @Override
    public ExecutePowerQueryActivityTypeProperties withSourceStagingConcurrency(Object sourceStagingConcurrency) {
        super.withSourceStagingConcurrency(sourceStagingConcurrency);
        return this;
    }

    @Override
    public void validate() {
        if (this.sinks() != null) {
            this.sinks().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.queries() != null) {
            this.queries().forEach(e -> e.validate());
        }
        if (this.dataFlow() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataFlow in model ExecutePowerQueryActivityTypeProperties"));
        }
        this.dataFlow().validate();
        if (this.staging() != null) {
            this.staging().validate();
        }
        if (this.integrationRuntime() != null) {
            this.integrationRuntime().validate();
        }
        if (this.continuationSettings() != null) {
            this.continuationSettings().validate();
        }
        if (this.compute() != null) {
            this.compute().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataFlow", (JsonSerializable)this.dataFlow());
        jsonWriter.writeJsonField("staging", (JsonSerializable)this.staging());
        jsonWriter.writeJsonField("integrationRuntime", (JsonSerializable)this.integrationRuntime());
        jsonWriter.writeJsonField("continuationSettings", (JsonSerializable)this.continuationSettings());
        jsonWriter.writeJsonField("compute", (JsonSerializable)this.compute());
        if (this.traceLevel() != null) {
            jsonWriter.writeUntypedField("traceLevel", this.traceLevel());
        }
        if (this.continueOnError() != null) {
            jsonWriter.writeUntypedField("continueOnError", this.continueOnError());
        }
        if (this.runConcurrently() != null) {
            jsonWriter.writeUntypedField("runConcurrently", this.runConcurrently());
        }
        if (this.sourceStagingConcurrency() != null) {
            jsonWriter.writeUntypedField("sourceStagingConcurrency", this.sourceStagingConcurrency());
        }
        jsonWriter.writeMapField("sinks", this.sinks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("queries", this.queries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExecutePowerQueryActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutePowerQueryActivityTypeProperties)jsonReader.readObject(reader -> {
            ExecutePowerQueryActivityTypeProperties deserializedExecutePowerQueryActivityTypeProperties = new ExecutePowerQueryActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataFlow".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withDataFlow(DataFlowReference.fromJson(reader));
                    continue;
                }
                if ("staging".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withStaging(DataFlowStagingInfo.fromJson(reader));
                    continue;
                }
                if ("integrationRuntime".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withIntegrationRuntime(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("continuationSettings".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withContinuationSettings(ContinuationSettingsReference.fromJson(reader));
                    continue;
                }
                if ("compute".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withCompute(ExecuteDataFlowActivityTypePropertiesCompute.fromJson(reader));
                    continue;
                }
                if ("traceLevel".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withTraceLevel(reader.readUntyped());
                    continue;
                }
                if ("continueOnError".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withContinueOnError(reader.readUntyped());
                    continue;
                }
                if ("runConcurrently".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withRunConcurrently(reader.readUntyped());
                    continue;
                }
                if ("sourceStagingConcurrency".equals(fieldName)) {
                    deserializedExecutePowerQueryActivityTypeProperties.withSourceStagingConcurrency(reader.readUntyped());
                    continue;
                }
                if ("sinks".equals(fieldName)) {
                    Map sinks;
                    deserializedExecutePowerQueryActivityTypeProperties.sinks = sinks = reader.readMap(reader1 -> PowerQuerySink.fromJson(reader1));
                    continue;
                }
                if ("queries".equals(fieldName)) {
                    List queries;
                    deserializedExecutePowerQueryActivityTypeProperties.queries = queries = reader.readArray(reader1 -> PowerQuerySinkMapping.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutePowerQueryActivityTypeProperties;
        });
    }
}

