/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LogStorageSettings;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;

public final class DeleteActivityTypeProperties
implements JsonSerializable<DeleteActivityTypeProperties> {
    private Object recursive;
    private Integer maxConcurrentConnections;
    private Object enableLogging;
    private LogStorageSettings logStorageSettings;
    private DatasetReference dataset;
    private StoreReadSettings storeSettings;
    private static final ClientLogger LOGGER = new ClientLogger(DeleteActivityTypeProperties.class);

    public Object recursive() {
        return this.recursive;
    }

    public DeleteActivityTypeProperties withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    public Integer maxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public DeleteActivityTypeProperties withMaxConcurrentConnections(Integer maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        return this;
    }

    public Object enableLogging() {
        return this.enableLogging;
    }

    public DeleteActivityTypeProperties withEnableLogging(Object enableLogging) {
        this.enableLogging = enableLogging;
        return this;
    }

    public LogStorageSettings logStorageSettings() {
        return this.logStorageSettings;
    }

    public DeleteActivityTypeProperties withLogStorageSettings(LogStorageSettings logStorageSettings) {
        this.logStorageSettings = logStorageSettings;
        return this;
    }

    public DatasetReference dataset() {
        return this.dataset;
    }

    public DeleteActivityTypeProperties withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public StoreReadSettings storeSettings() {
        return this.storeSettings;
    }

    public DeleteActivityTypeProperties withStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public void validate() {
        if (this.logStorageSettings() != null) {
            this.logStorageSettings().validate();
        }
        if (this.dataset() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataset in model DeleteActivityTypeProperties"));
        }
        this.dataset().validate();
        if (this.storeSettings() != null) {
            this.storeSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
        if (this.recursive != null) {
            jsonWriter.writeUntypedField("recursive", this.recursive);
        }
        jsonWriter.writeNumberField("maxConcurrentConnections", (Number)this.maxConcurrentConnections);
        if (this.enableLogging != null) {
            jsonWriter.writeUntypedField("enableLogging", this.enableLogging);
        }
        jsonWriter.writeJsonField("logStorageSettings", (JsonSerializable)this.logStorageSettings);
        jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
        return jsonWriter.writeEndObject();
    }

    public static DeleteActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeleteActivityTypeProperties)jsonReader.readObject(reader -> {
            DeleteActivityTypeProperties deserializedDeleteActivityTypeProperties = new DeleteActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataset".equals(fieldName)) {
                    deserializedDeleteActivityTypeProperties.dataset = DatasetReference.fromJson(reader);
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedDeleteActivityTypeProperties.recursive = reader.readUntyped();
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedDeleteActivityTypeProperties.maxConcurrentConnections = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableLogging".equals(fieldName)) {
                    deserializedDeleteActivityTypeProperties.enableLogging = reader.readUntyped();
                    continue;
                }
                if ("logStorageSettings".equals(fieldName)) {
                    deserializedDeleteActivityTypeProperties.logStorageSettings = LogStorageSettings.fromJson(reader);
                    continue;
                }
                if ("storeSettings".equals(fieldName)) {
                    deserializedDeleteActivityTypeProperties.storeSettings = StoreReadSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeleteActivityTypeProperties;
        });
    }
}

