/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.Map;

public final class DataLakeAnalyticsUsqlActivityTypeProperties
implements JsonSerializable<DataLakeAnalyticsUsqlActivityTypeProperties> {
    private Object scriptPath;
    private LinkedServiceReference scriptLinkedService;
    private Object degreeOfParallelism;
    private Object priority;
    private Map<String, Object> parameters;
    private Object runtimeVersion;
    private Object compilationMode;
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeAnalyticsUsqlActivityTypeProperties.class);

    public Object scriptPath() {
        return this.scriptPath;
    }

    public DataLakeAnalyticsUsqlActivityTypeProperties withScriptPath(Object scriptPath) {
        this.scriptPath = scriptPath;
        return this;
    }

    public LinkedServiceReference scriptLinkedService() {
        return this.scriptLinkedService;
    }

    public DataLakeAnalyticsUsqlActivityTypeProperties withScriptLinkedService(LinkedServiceReference scriptLinkedService) {
        this.scriptLinkedService = scriptLinkedService;
        return this;
    }

    public Object degreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public DataLakeAnalyticsUsqlActivityTypeProperties withDegreeOfParallelism(Object degreeOfParallelism) {
        this.degreeOfParallelism = degreeOfParallelism;
        return this;
    }

    public Object priority() {
        return this.priority;
    }

    public DataLakeAnalyticsUsqlActivityTypeProperties withPriority(Object priority) {
        this.priority = priority;
        return this;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public DataLakeAnalyticsUsqlActivityTypeProperties withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Object runtimeVersion() {
        return this.runtimeVersion;
    }

    public DataLakeAnalyticsUsqlActivityTypeProperties withRuntimeVersion(Object runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    public Object compilationMode() {
        return this.compilationMode;
    }

    public DataLakeAnalyticsUsqlActivityTypeProperties withCompilationMode(Object compilationMode) {
        this.compilationMode = compilationMode;
        return this;
    }

    public void validate() {
        if (this.scriptPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scriptPath in model DataLakeAnalyticsUsqlActivityTypeProperties"));
        }
        if (this.scriptLinkedService() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scriptLinkedService in model DataLakeAnalyticsUsqlActivityTypeProperties"));
        }
        this.scriptLinkedService().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("scriptPath", this.scriptPath);
        jsonWriter.writeJsonField("scriptLinkedService", (JsonSerializable)this.scriptLinkedService);
        if (this.degreeOfParallelism != null) {
            jsonWriter.writeUntypedField("degreeOfParallelism", this.degreeOfParallelism);
        }
        if (this.priority != null) {
            jsonWriter.writeUntypedField("priority", this.priority);
        }
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        if (this.runtimeVersion != null) {
            jsonWriter.writeUntypedField("runtimeVersion", this.runtimeVersion);
        }
        if (this.compilationMode != null) {
            jsonWriter.writeUntypedField("compilationMode", this.compilationMode);
        }
        return jsonWriter.writeEndObject();
    }

    public static DataLakeAnalyticsUsqlActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataLakeAnalyticsUsqlActivityTypeProperties)jsonReader.readObject(reader -> {
            DataLakeAnalyticsUsqlActivityTypeProperties deserializedDataLakeAnalyticsUsqlActivityTypeProperties = new DataLakeAnalyticsUsqlActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scriptPath".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivityTypeProperties.scriptPath = reader.readUntyped();
                    continue;
                }
                if ("scriptLinkedService".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivityTypeProperties.scriptLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("degreeOfParallelism".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivityTypeProperties.degreeOfParallelism = reader.readUntyped();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivityTypeProperties.priority = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDataLakeAnalyticsUsqlActivityTypeProperties.parameters = parameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("runtimeVersion".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivityTypeProperties.runtimeVersion = reader.readUntyped();
                    continue;
                }
                if ("compilationMode".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivityTypeProperties.compilationMode = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataLakeAnalyticsUsqlActivityTypeProperties;
        });
    }
}

