/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ChangeDataCaptureFolder;
import com.azure.resourcemanager.datafactory.models.MapperPolicy;
import com.azure.resourcemanager.datafactory.models.MapperSourceConnectionsInfo;
import com.azure.resourcemanager.datafactory.models.MapperTargetConnectionsInfo;
import java.io.IOException;
import java.util.List;

public final class ChangeDataCapture
implements JsonSerializable<ChangeDataCapture> {
    private ChangeDataCaptureFolder folder;
    private String description;
    private List<MapperSourceConnectionsInfo> sourceConnectionsInfo;
    private List<MapperTargetConnectionsInfo> targetConnectionsInfo;
    private MapperPolicy policy;
    private Boolean allowVNetOverride;
    private String status;
    private static final ClientLogger LOGGER = new ClientLogger(ChangeDataCapture.class);

    public ChangeDataCaptureFolder folder() {
        return this.folder;
    }

    public ChangeDataCapture withFolder(ChangeDataCaptureFolder folder) {
        this.folder = folder;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ChangeDataCapture withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<MapperSourceConnectionsInfo> sourceConnectionsInfo() {
        return this.sourceConnectionsInfo;
    }

    public ChangeDataCapture withSourceConnectionsInfo(List<MapperSourceConnectionsInfo> sourceConnectionsInfo) {
        this.sourceConnectionsInfo = sourceConnectionsInfo;
        return this;
    }

    public List<MapperTargetConnectionsInfo> targetConnectionsInfo() {
        return this.targetConnectionsInfo;
    }

    public ChangeDataCapture withTargetConnectionsInfo(List<MapperTargetConnectionsInfo> targetConnectionsInfo) {
        this.targetConnectionsInfo = targetConnectionsInfo;
        return this;
    }

    public MapperPolicy policy() {
        return this.policy;
    }

    public ChangeDataCapture withPolicy(MapperPolicy policy) {
        this.policy = policy;
        return this;
    }

    public Boolean allowVNetOverride() {
        return this.allowVNetOverride;
    }

    public ChangeDataCapture withAllowVNetOverride(Boolean allowVNetOverride) {
        this.allowVNetOverride = allowVNetOverride;
        return this;
    }

    public String status() {
        return this.status;
    }

    public ChangeDataCapture withStatus(String status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.folder() != null) {
            this.folder().validate();
        }
        if (this.sourceConnectionsInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionsInfo in model ChangeDataCapture"));
        }
        this.sourceConnectionsInfo().forEach(e -> e.validate());
        if (this.targetConnectionsInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionsInfo in model ChangeDataCapture"));
        }
        this.targetConnectionsInfo().forEach(e -> e.validate());
        if (this.policy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policy in model ChangeDataCapture"));
        }
        this.policy().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sourceConnectionsInfo", this.sourceConnectionsInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("targetConnectionsInfo", this.targetConnectionsInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("allowVNetOverride", this.allowVNetOverride);
        jsonWriter.writeStringField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    public static ChangeDataCapture fromJson(JsonReader jsonReader) throws IOException {
        return (ChangeDataCapture)jsonReader.readObject(reader -> {
            ChangeDataCapture deserializedChangeDataCapture = new ChangeDataCapture();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionsInfo".equals(fieldName)) {
                    List sourceConnectionsInfo;
                    deserializedChangeDataCapture.sourceConnectionsInfo = sourceConnectionsInfo = reader.readArray(reader1 -> MapperSourceConnectionsInfo.fromJson(reader1));
                    continue;
                }
                if ("targetConnectionsInfo".equals(fieldName)) {
                    List targetConnectionsInfo;
                    deserializedChangeDataCapture.targetConnectionsInfo = targetConnectionsInfo = reader.readArray(reader1 -> MapperTargetConnectionsInfo.fromJson(reader1));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedChangeDataCapture.policy = MapperPolicy.fromJson(reader);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedChangeDataCapture.folder = ChangeDataCaptureFolder.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedChangeDataCapture.description = reader.getString();
                    continue;
                }
                if ("allowVNetOverride".equals(fieldName)) {
                    deserializedChangeDataCapture.allowVNetOverride = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedChangeDataCapture.status = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChangeDataCapture;
        });
    }
}

