/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public class AzureStorageLinkedServiceTypeProperties
implements JsonSerializable<AzureStorageLinkedServiceTypeProperties> {
    private Object connectionString;
    private AzureKeyVaultSecretReference accountKey;
    private Object sasUri;
    private AzureKeyVaultSecretReference sasToken;
    private String encryptedCredential;

    public Object connectionString() {
        return this.connectionString;
    }

    public AzureStorageLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference accountKey() {
        return this.accountKey;
    }

    public AzureStorageLinkedServiceTypeProperties withAccountKey(AzureKeyVaultSecretReference accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object sasUri() {
        return this.sasUri;
    }

    public AzureStorageLinkedServiceTypeProperties withSasUri(Object sasUri) {
        this.sasUri = sasUri;
        return this;
    }

    public AzureKeyVaultSecretReference sasToken() {
        return this.sasToken;
    }

    public AzureStorageLinkedServiceTypeProperties withSasToken(AzureKeyVaultSecretReference sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureStorageLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.accountKey() != null) {
            this.accountKey().validate();
        }
        if (this.sasToken() != null) {
            this.sasToken().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.accountKey);
        if (this.sasUri != null) {
            jsonWriter.writeUntypedField("sasUri", this.sasUri);
        }
        jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.sasToken);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static AzureStorageLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureStorageLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureStorageLinkedServiceTypeProperties deserializedAzureStorageLinkedServiceTypeProperties = new AzureStorageLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureStorageLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureStorageLinkedServiceTypeProperties.accountKey = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("sasUri".equals(fieldName)) {
                    deserializedAzureStorageLinkedServiceTypeProperties.sasUri = reader.readUntyped();
                    continue;
                }
                if ("sasToken".equals(fieldName)) {
                    deserializedAzureStorageLinkedServiceTypeProperties.sasToken = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureStorageLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureStorageLinkedServiceTypeProperties;
        });
    }
}

