/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureMLServiceLinkedServiceTypeProperties
implements JsonSerializable<AzureMLServiceLinkedServiceTypeProperties> {
    private Object subscriptionId;
    private Object resourceGroupName;
    private Object mlWorkspaceName;
    private Object authentication;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(AzureMLServiceLinkedServiceTypeProperties.class);

    public Object subscriptionId() {
        return this.subscriptionId;
    }

    public AzureMLServiceLinkedServiceTypeProperties withSubscriptionId(Object subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public Object resourceGroupName() {
        return this.resourceGroupName;
    }

    public AzureMLServiceLinkedServiceTypeProperties withResourceGroupName(Object resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public Object mlWorkspaceName() {
        return this.mlWorkspaceName;
    }

    public AzureMLServiceLinkedServiceTypeProperties withMlWorkspaceName(Object mlWorkspaceName) {
        this.mlWorkspaceName = mlWorkspaceName;
        return this;
    }

    public Object authentication() {
        return this.authentication;
    }

    public AzureMLServiceLinkedServiceTypeProperties withAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureMLServiceLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureMLServiceLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureMLServiceLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureMLServiceLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model AzureMLServiceLinkedServiceTypeProperties"));
        }
        if (this.resourceGroupName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroupName in model AzureMLServiceLinkedServiceTypeProperties"));
        }
        if (this.mlWorkspaceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mlWorkspaceName in model AzureMLServiceLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("subscriptionId", this.subscriptionId);
        jsonWriter.writeUntypedField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeUntypedField("mlWorkspaceName", this.mlWorkspaceName);
        if (this.authentication != null) {
            jsonWriter.writeUntypedField("authentication", this.authentication);
        }
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static AzureMLServiceLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLServiceLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureMLServiceLinkedServiceTypeProperties deserializedAzureMLServiceLinkedServiceTypeProperties = new AzureMLServiceLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subscriptionId".equals(fieldName)) {
                    deserializedAzureMLServiceLinkedServiceTypeProperties.subscriptionId = reader.readUntyped();
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedAzureMLServiceLinkedServiceTypeProperties.resourceGroupName = reader.readUntyped();
                    continue;
                }
                if ("mlWorkspaceName".equals(fieldName)) {
                    deserializedAzureMLServiceLinkedServiceTypeProperties.mlWorkspaceName = reader.readUntyped();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedAzureMLServiceLinkedServiceTypeProperties.authentication = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureMLServiceLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureMLServiceLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureMLServiceLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureMLServiceLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureMLServiceLinkedServiceTypeProperties;
        });
    }
}

