/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureDataLakeStoreLinkedServiceTypeProperties
implements JsonSerializable<AzureDataLakeStoreLinkedServiceTypeProperties> {
    private Object dataLakeStoreUri;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object azureCloudType;
    private Object accountName;
    private Object subscriptionId;
    private Object resourceGroupName;
    private String encryptedCredential;
    private CredentialReference credential;
    private static final ClientLogger LOGGER = new ClientLogger(AzureDataLakeStoreLinkedServiceTypeProperties.class);

    public Object dataLakeStoreUri() {
        return this.dataLakeStoreUri;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withDataLakeStoreUri(Object dataLakeStoreUri) {
        this.dataLakeStoreUri = dataLakeStoreUri;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object azureCloudType() {
        return this.azureCloudType;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object accountName() {
        return this.accountName;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withAccountName(Object accountName) {
        this.accountName = accountName;
        return this;
    }

    public Object subscriptionId() {
        return this.subscriptionId;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withSubscriptionId(Object subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public Object resourceGroupName() {
        return this.resourceGroupName;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withResourceGroupName(Object resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureDataLakeStoreLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.dataLakeStoreUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataLakeStoreUri in model AzureDataLakeStoreLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("dataLakeStoreUri", this.dataLakeStoreUri);
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        if (this.azureCloudType != null) {
            jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        }
        if (this.accountName != null) {
            jsonWriter.writeUntypedField("accountName", this.accountName);
        }
        if (this.subscriptionId != null) {
            jsonWriter.writeUntypedField("subscriptionId", this.subscriptionId);
        }
        if (this.resourceGroupName != null) {
            jsonWriter.writeUntypedField("resourceGroupName", this.resourceGroupName);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureDataLakeStoreLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataLakeStoreLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureDataLakeStoreLinkedServiceTypeProperties deserializedAzureDataLakeStoreLinkedServiceTypeProperties = new AzureDataLakeStoreLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataLakeStoreUri".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.dataLakeStoreUri = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("accountName".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.accountName = reader.readUntyped();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.subscriptionId = reader.readUntyped();
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.resourceGroupName = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureDataLakeStoreLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureDataLakeStoreLinkedServiceTypeProperties;
        });
    }
}

