/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.UserAccessPolicy;
import java.io.IOException;

public final class AccessPolicyResponseInner
implements JsonSerializable<AccessPolicyResponseInner> {
    private UserAccessPolicy policy;
    private String accessToken;
    private String dataPlaneUrl;

    public UserAccessPolicy policy() {
        return this.policy;
    }

    public AccessPolicyResponseInner withPolicy(UserAccessPolicy policy) {
        this.policy = policy;
        return this;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public AccessPolicyResponseInner withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String dataPlaneUrl() {
        return this.dataPlaneUrl;
    }

    public AccessPolicyResponseInner withDataPlaneUrl(String dataPlaneUrl) {
        this.dataPlaneUrl = dataPlaneUrl;
        return this;
    }

    public void validate() {
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("dataPlaneUrl", this.dataPlaneUrl);
        return jsonWriter.writeEndObject();
    }

    public static AccessPolicyResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (AccessPolicyResponseInner)jsonReader.readObject(reader -> {
            AccessPolicyResponseInner deserializedAccessPolicyResponseInner = new AccessPolicyResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policy".equals(fieldName)) {
                    deserializedAccessPolicyResponseInner.policy = UserAccessPolicy.fromJson(reader);
                    continue;
                }
                if ("accessToken".equals(fieldName)) {
                    deserializedAccessPolicyResponseInner.accessToken = reader.getString();
                    continue;
                }
                if ("dataPlaneUrl".equals(fieldName)) {
                    deserializedAccessPolicyResponseInner.dataPlaneUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessPolicyResponseInner;
        });
    }
}

