/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RestorableLocationResource
implements JsonSerializable<RestorableLocationResource> {
    private String locationName;
    private String regionalDatabaseAccountInstanceId;
    private OffsetDateTime creationTime;
    private OffsetDateTime deletionTime;

    public String locationName() {
        return this.locationName;
    }

    public String regionalDatabaseAccountInstanceId() {
        return this.regionalDatabaseAccountInstanceId;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime deletionTime() {
        return this.deletionTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RestorableLocationResource fromJson(JsonReader jsonReader) throws IOException {
        return (RestorableLocationResource)jsonReader.readObject(reader -> {
            RestorableLocationResource deserializedRestorableLocationResource = new RestorableLocationResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locationName".equals(fieldName)) {
                    deserializedRestorableLocationResource.locationName = reader.getString();
                    continue;
                }
                if ("regionalDatabaseAccountInstanceId".equals(fieldName)) {
                    deserializedRestorableLocationResource.regionalDatabaseAccountInstanceId = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedRestorableLocationResource.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("deletionTime".equals(fieldName)) {
                    deserializedRestorableLocationResource.deletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableLocationResource;
        });
    }
}

