/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.SqlTriggerResource;
import java.io.IOException;

public final class SqlTriggerCreateUpdateProperties
implements JsonSerializable<SqlTriggerCreateUpdateProperties> {
    private SqlTriggerResource resource;
    private CreateUpdateOptions options;
    private static final ClientLogger LOGGER = new ClientLogger(SqlTriggerCreateUpdateProperties.class);

    public SqlTriggerResource resource() {
        return this.resource;
    }

    public SqlTriggerCreateUpdateProperties withResource(SqlTriggerResource resource) {
        this.resource = resource;
        return this;
    }

    public CreateUpdateOptions options() {
        return this.options;
    }

    public SqlTriggerCreateUpdateProperties withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model SqlTriggerCreateUpdateProperties"));
        }
        this.resource().validate();
        if (this.options() != null) {
            this.options().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        jsonWriter.writeJsonField("options", (JsonSerializable)this.options);
        return jsonWriter.writeEndObject();
    }

    public static SqlTriggerCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlTriggerCreateUpdateProperties)jsonReader.readObject(reader -> {
            SqlTriggerCreateUpdateProperties deserializedSqlTriggerCreateUpdateProperties = new SqlTriggerCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedSqlTriggerCreateUpdateProperties.resource = SqlTriggerResource.fromJson(reader);
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedSqlTriggerCreateUpdateProperties.options = CreateUpdateOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlTriggerCreateUpdateProperties;
        });
    }
}

